package android.library.util

import android.util.Log

/**
 * 日志工具类
 */
class QXLogUtil private constructor() {
    companion object {
        private var mDebug = false
        private const val mTag = "「 QX 」"

        @JvmStatic
        fun init(debug: Boolean) {
            mDebug = debug
        }

        @JvmStatic
        fun d(msg: String) {
            if (mDebug) {
                d("", msg)
            }
        }

        @JvmStatic
        fun e(msg: String) {
            if (mDebug) {
                e("", msg)
            }
        }

        @JvmStatic
        fun i(msg: String) {
            if (mDebug) {
                i("", msg)
            }
        }

        @JvmStatic
        fun v(msg: String) {
            if (mDebug) {
                v("", msg)
            }
        }

        @JvmStatic
        fun d(tag: String, msg: String) {
            if (mDebug) {
                Log.d(mTag + tag, msg)
            }
        }

        @JvmStatic
        fun e(tag: String, msg: String) {
            if (mDebug) {
                Log.e(mTag + tag, msg)
            }
        }

        @JvmStatic
        fun i(tag: String, msg: String) {
            if (mDebug) {
                Log.i(mTag + tag, msg)
            }
        }

        @JvmStatic
        fun v(tag: String, msg: String) {
            if (mDebug) {
                Log.v(mTag + tag, msg)
            }
        }

    }
}