package android.library.util

import android.util.Log

/**
 * 日志工具类
 */
class LogUtil private constructor(){
    companion object {
        private var mDebug = true
        private const val mTag = "【 日志 】"

        @JvmStatic
        fun init(debug: Boolean) {
            mDebug = debug
        }

        @JvmStatic
        fun d(msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                d(mTag, msg)
            }
        }

        @JvmStatic
        fun e(msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                e(mTag, msg)
            }
        }

        @JvmStatic
        fun i(msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                i(mTag, msg)
            }
        }

        @JvmStatic
        fun v(msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                v(mTag, msg)
            }
        }

        @JvmStatic
        fun d(tag: String, msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                Log.d(tag, msg)
            }
        }

        @JvmStatic
        fun e(tag: String, msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                Log.e(tag, msg)
            }
        }

        @JvmStatic
        fun i(tag: String, msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                Log.i(tag, msg)
            }
        }

        @JvmStatic
        fun v(tag: String, msg: String) {
            if (mDebug && BuildConfig.DEBUG) {
                Log.v(tag, msg)
            }
        }

    }
}