package android.library.util.permission;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.core.content.ContextCompat;

/**
 * 权限申请工具类
 */
public class EasyPermission {
    private Activity mActivity;
    private OnEasyPermissionListener mOnEasyPermissionListener;

    private String[] mPermissions;

    public EasyPermission(Activity mActivity) {
        this.mActivity = mActivity;
    }

    /**
     * 初始化
     * @param activity 当前activity
     * @return 返回EasyPermission
     */
    public static EasyPermission init(Activity activity) {
        return new EasyPermission(activity);
    }

    /**
     * 添加权限
     * @param permission 需要申请的权限
     * @return 返回EasyPermission
     */
    public EasyPermission permission(String... permission) {
        mPermissions = permission;
        return this;
    }

    /**
     * 开始申请权限
     * @param onEasyPermissionListener 权限申请监听
     */
    public void builder(OnEasyPermissionListener onEasyPermissionListener) {
        mOnEasyPermissionListener = onEasyPermissionListener;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            request23ToActivity();
        } else {
            mOnEasyPermissionListener.onYes();
        }
    }

    /**
     * sdk23以上申请权限
     */
    private void request23ToActivity() {
        if (checkPermission()) {
            EasyPermissionFragment.getInstance(mPermissions).request(mActivity, mOnEasyPermissionListener);
        } else {
            mOnEasyPermissionListener.onYes();
        }
    }

    /**
     * 检查权限
     * @return true:需要申请；false:已申请
     */
    private boolean checkPermission() {
        for (int i = 0; i < mPermissions.length; i++) {
            if (ContextCompat.checkSelfPermission(mActivity, mPermissions[i]) != PackageManager.PERMISSION_GRANTED) {
                return true;
            }
        }
        return false;
    }
}
