package android.library.util.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.library.util.R;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.*;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import java.util.List;

/**
 * 列表dialog弹窗，宽度为屏幕宽度十分之九
 * 实例化时传入上下午以及数据源
 * setOnListItemClickListener()方法实现对列表的点击事件监听
 */
public abstract class ChooseListDialog<T> extends Dialog implements AdapterView.OnItemClickListener {

    private Context context;
    private List<T> list;

    private ListDialogAdapter adapter;
    private OnListItemClickListener listener;

    public ChooseListDialog(@NonNull Context context, List<T> list) {
        super(context);
        this.context = context;
        this.list = list;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.CENTER);

        ListView listView = new ListView(getContext());
        listView.setDivider(new ColorDrawable(ContextCompat.getColor(context,R.color.dividerColor)));
        listView.setDividerHeight(1);
        adapter = new ListDialogAdapter(list);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(this);

        setContentView(listView);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        if (listener != null) {
            listener.onItemClick(list.get(position), position);
        }
    }


    public interface OnListItemClickListener {
        void onItemClick(Object t, int position);
    }

    public ChooseListDialog show(OnListItemClickListener onItemClickListener) {
        this.listener = listener;

        show();
        return this;
    }

    private class ListDialogAdapter extends BaseAdapter {
        private List<T> mList;

        public ListDialogAdapter(List<T> mList) {
            this.mList = mList;
        }

        @Override
        public int getCount() {
            return mList.size();
        }

        @Override
        public T getItem(int position) {
            return mList.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder ho = null;
            if (convertView == null) {
                convertView = LayoutInflater.from(getContext()).inflate(R.layout.ui_item_list_dialog, null);
                ho = new ViewHolder(convertView);
                convertView.setTag(ho);
            } else {
                ho = (ViewHolder) convertView.getTag();
            }
            onBindData(ho.textView, getItem(position));
            return convertView;
        }

        class ViewHolder {
            private TextView textView;

            public ViewHolder(@NonNull View itemView) {
                textView = itemView.findViewById(R.id.uiItemListDialog_text);
            }
        }
    }

    public abstract void onBindData(TextView view, T t);
}
