package android.library.util.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;

import android.library.util.R;

/**
 * 底部弹出dialog，宽度为屏幕宽度十分之九
 * 实例化时传入布局id和布局中控件的id
 * 可通过setOnBottomMenuItemClickListener()方法实现对传入控件的点击事件监听
 */
public class BottomClickDialog extends Dialog implements View.OnClickListener {

    private Context context;
    private int layoutResID;

    /**
     * 要监听的控件id
     */
    private int[] listenedItems;

    private OnBottomMenuItemClickListener listener;

    public BottomClickDialog(@NonNull Context context, int layoutResID, int[] listenedItems) {
        super(context, R.style.bottom_dialog_custom);
        this.context = context;
        this.layoutResID = layoutResID;
        this.listenedItems = listenedItems;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = getWindow();
        window.setGravity(Gravity.BOTTOM);
        window.setWindowAnimations(R.style.bottom_menu_animation);
        setContentView(layoutResID);
        WindowManager manager = ((Activity) context).getWindowManager();
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        WindowManager.LayoutParams lp = getWindow().getAttributes();
        lp.width = outMetrics.widthPixels * 9 / 10;
        getWindow().setAttributes(lp);
        setCanceledOnTouchOutside(true);
        for (int id : listenedItems) {
            findViewById(id).setOnClickListener(this);
        }
    }


    public interface OnBottomMenuItemClickListener {
        void onBottomMenuItemClick(BottomClickDialog dialog, View view);

    }

    public void setOnBottomMenuItemClickListener(OnBottomMenuItemClickListener listener) {
        this.listener = listener;
    }

    @Override
    public void onClick(View view) {
        dismiss();
        listener.onBottomMenuItemClick(this, view);
    }

}
