package android.library.util;

import android.app.Application;
import android.content.Context;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BaseApplication extends Application {

    private static BaseApplication baseApplication;
    private static Context context;

    @Override
    public void onCreate() {
        super.onCreate();
        baseApplication = this;
        context = this;
        closeAndroidPDialog();
    }

    public static Context getContext() {
        return context;
    }

    public static Application getApplication() {
        return baseApplication;
    }

    /**
     * api28调用私有方法隐藏弹窗提示
     */
    @SuppressWarnings("unchecked")
    public static void closeAndroidPDialog() {
        if (BuildConfig.DEBUG) {
            try {
                Class aClass = Class.forName("android.content.pm.PackageParser$Package");
                Constructor declaredConstructor = aClass.getDeclaredConstructor(String.class);
                declaredConstructor.setAccessible(true);
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Class cls = Class.forName("android.app.ActivityThread");
                Method declaredMethod = cls.getDeclaredMethod("currentActivityThread");
                declaredMethod.setAccessible(true);
                Object activityThread = declaredMethod.invoke(null);
                Field mHiddenApiWarningShown = cls.getDeclaredField("mHiddenApiWarningShown");
                mHiddenApiWarningShown.setAccessible(true);
                mHiddenApiWarningShown.setBoolean(activityThread, true);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}
