package cn.lsmya.retrofit;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.converter.gson.GsonConverterFactory;

public abstract class OnRetrofitSetting {

    public abstract String baseUrl();

    public abstract boolean debug();

    public OkHttpClient okHttpClient() {
        return null;
    }

    public Converter.Factory converterFactory() {
        return GsonConverterFactory.create();
    }

    public Interceptor networkInterceptor() {
        return (new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
    }
}
