package cn.lsmya.retrofit;

import com.jakewharton.retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

import java.util.concurrent.TimeUnit;

import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class RetrofitHelper {

    private static RetrofitHelper instance;
    private static OnRetrofitSetting mOnRetrofitSetting;
    private OkHttpClient mOkHttpClient;
    private Retrofit mRetrofit;
    private Retrofit mNoFactoryRetrofit;

    public static void setOnRetrofitSetting(OnRetrofitSetting onRetrofitSetting) {
        mOnRetrofitSetting = onRetrofitSetting;
    }

    private OkHttpClient getOkHttpClient() {
        if (mOnRetrofitSetting == null) {
            if (mOkHttpClient == null) {
                mOkHttpClient = new OkHttpClient().newBuilder()
                        .connectTimeout(10, TimeUnit.SECONDS)
                        .readTimeout(10, TimeUnit.SECONDS)
                        .writeTimeout(10, TimeUnit.SECONDS)
                        .build();
            }
        } else {
            if (mOnRetrofitSetting.okHttpClient() == null) {
                OkHttpClient.Builder builder = new OkHttpClient().newBuilder()
                        .connectTimeout(10, TimeUnit.SECONDS)
                        .readTimeout(10, TimeUnit.SECONDS)
                        .writeTimeout(10, TimeUnit.SECONDS);
                if (mOnRetrofitSetting.debug()) {
                    builder.addNetworkInterceptor(new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY));
                }
                mOkHttpClient = builder.build();
            } else {
                mOkHttpClient = mOnRetrofitSetting.okHttpClient();
            }
        }
        return mOkHttpClient;
    }

    private Retrofit createRetrofit() {
        if (mRetrofit == null) {
            mRetrofit = new Retrofit.Builder()
                    .baseUrl(getBaseUrl())
                    .addConverterFactory(getConverterFactory())
                    .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                    .client(getOkHttpClient()).build();
        }
        return mRetrofit;
    }

    private Retrofit createNoFactoryRetrofit() {
        if (mNoFactoryRetrofit == null) {
            mNoFactoryRetrofit = new Retrofit.Builder()
                    .baseUrl(getBaseUrl())
                    .addCallAdapterFactory(RxJava2CallAdapterFactory.create())
                    .client(getOkHttpClient()).build();
        }
        return mNoFactoryRetrofit;
    }

    private static String getBaseUrl() {
        return mOnRetrofitSetting == null ? null : mOnRetrofitSetting.baseUrl();
    }

    private Converter.Factory getConverterFactory() {
        return mOnRetrofitSetting == null ? null : mOnRetrofitSetting.converterFactory();
    }

    /**
     * 创建 Retrofit
     *
     * @return Retrofit
     */
    public static synchronized Retrofit getRetrofit() {
        return getInstance().createRetrofit();
    }

    /**
     * 创建 Retrofit
     *
     * @return Retrofit
     */
    public static synchronized Retrofit getNoFactoryRetrofit() {
        return getInstance().createNoFactoryRetrofit();
    }

    /**
     * 单例 获取
     *
     * @return BaseApi
     */
    private static synchronized RetrofitHelper getInstance() {
        if (instance == null) {
            instance = new RetrofitHelper();
        }
        return instance;
    }

}
