package cn.lsmya.office;

import android.os.Bundle;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;

import com.tencent.smtt.sdk.TbsReaderView;

import java.io.File;

public class OfficeActivity extends AppCompatActivity {
    private TbsReaderView mTbsReaderView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTheme(getIntent().getIntExtra("theme", R.style.helper_open_office_theme));
        setContentView(R.layout.helper_activity_open_file);
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        }
        String filePath = getIntent().getStringExtra("filePath");
        RelativeLayout layout = findViewById(R.id.helperOpenFile_layout);
        mTbsReaderView = new TbsReaderView(this, null);
        layout.addView(mTbsReaderView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        setTitle(getIntent().getStringExtra("title"));
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putString("tempPath", new File(filePath).getParent());
        boolean result = mTbsReaderView.preOpen(parseFormat(new File(filePath).getName()), false);
        if (result) {
            mTbsReaderView.openFile(bundle);
        }
    }

    private String parseFormat(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            finish();
            return false;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            mTbsReaderView.onStop();
        } catch (Exception e) {
        }
    }
}
