package cn.lsmya.office;

import android.os.Bundle;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import com.tencent.smtt.sdk.TbsReaderView;

import java.io.File;

public class OpenFileHelper extends AppCompatActivity {
    private TbsReaderView mTbsReaderView;
    private RelativeLayout layout;
    private Toolbar toolbar;
    private String filePath;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTheme(getIntent().getIntExtra("theme", R.style.helper_open_office_theme));
        setContentView(R.layout.helper_activity_open_file);
        filePath = getIntent().getStringExtra("filePath");
        layout = findViewById(R.id.helperOpenFile_layout);
        toolbar = findViewById(R.id.helperOpenFile_toolbar);
        toolbar.setNavigationIcon(R.drawable.hepler_office_open_back);
        mTbsReaderView = new TbsReaderView(this, null);
        layout.addView(mTbsReaderView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        toolbar.setTitle(getIntent().getStringExtra("title"));
        setSupportActionBar(toolbar);
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putString("tempPath", new File(filePath).getParent());
        boolean result = mTbsReaderView.preOpen(parseFormat(new File(filePath).getName()), false);
        if (result) {
            mTbsReaderView.openFile(bundle);
        }
    }

    private String parseFormat(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            finish();
            return false;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            mTbsReaderView.onStop();
        } catch (Exception e) {
        }
    }
}
