package cn.lsmya.office;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;

import com.tencent.smtt.sdk.QbSdk;

/**
 * Office文件操作工具类
 * @author lsmya
 */
public class OfficeHelper {

    /**
     * 初始化
     *
     * @param context 上下文
     */
    public static void init(@NonNull Context context) {
        init(context, null);
    }

    /**
     * 初始化
     *
     * @param context 上下文
     * @param callback 初始化监听回调
     */
    public static void init(@NonNull Context context, QbSdk.PreInitCallback callback) {
        QbSdk.setDownloadWithoutWifi(true);
        if (callback == null) {
            callback = new QbSdk.PreInitCallback() {

                @Override
                public void onCoreInitFinished() {

                }

                @Override
                public void onViewInitFinished(boolean b) {
                    Log.d("TBS", b ? "SUCCESS" : "FAILURE");
                }
            };
        }
        QbSdk.initX5Environment(context, callback);
    }

    public static void open(@NonNull Activity activity, String filePath) {
        open(activity, R.string.office_title, filePath);
    }

    public static void open(@NonNull Activity activity, String filePath, @StyleRes int theme) {
        open(activity, R.string.office_title, filePath, theme);
    }

    public static void open(@NonNull Activity activity, String title, String filePath) {
        open(activity, title, filePath, R.style.helper_open_office_theme);
    }

    public static void open(@NonNull Activity activity, @StringRes int title, String filePath) {
        open(activity, title, filePath, R.style.helper_open_office_theme);
    }

    public static void open(@NonNull Activity activity, @StringRes int title, String filePath, @StyleRes int theme) {
        open(activity, activity.getString(title), filePath, theme);
    }

    public static void open(@NonNull Activity activity, String title, String filePath, @StyleRes int theme) {
        Intent intent = new Intent(activity, OpenFileHelper.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        intent.putExtra("theme", theme);
        activity.startActivity(intent);
    }

    public static void open(@NonNull Activity activity, String filePath, @StyleRes int theme, int requestCode) {
        open(activity, activity.getString(R.string.office_title), filePath, theme, requestCode);
    }

    public static void open(@NonNull Activity activity, String title, String filePath, @StyleRes int theme, int requestCode) {
        Intent intent = new Intent(activity, OpenFileHelper.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        intent.putExtra("theme", theme);
        activity.startActivityForResult(intent, requestCode);
    }
}
