package cn.lsmya.rxkit.view.recyclerview;

import android.util.SparseArray;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.RecyclerView;

/**
 * recyclerView的viewHolder封装
 */
public class RxViewHolder extends RecyclerView.ViewHolder {
    private final SparseArray<View> views;
    private RxBaseViewAdapter.OnChildClickListener onChildClickListener;

    public RxViewHolder(View itemView, RxBaseViewAdapter.OnChildClickListener onChildClickListener) {
        super(itemView);
        views = new SparseArray<>();
        this.onChildClickListener = onChildClickListener;
    }

    public RxViewHolder setVisibility(int viewId, int visibility) {
        getView(viewId).setVisibility(visibility);
        return this;
    }

    public RxViewHolder setText(int viewId, String content) {
        getTextView(viewId).setText(content);
        return this;
    }

    public RxViewHolder setTextColor(int viewId, int color) {
        getTextView(viewId).setTextColor(color);
        return this;
    }

    public RxViewHolder setImage(int viewId, int resource) {
        getImageView(viewId).setImageResource(resource);
        return this;
    }

    public RxViewHolder setOnClick(int viewId) {
        setOnClick(viewId, viewId);
        return this;
    }

    public RxViewHolder setOnClick(int viewId, int id) {
        if (onChildClickListener != null) {
            getView(viewId).setOnClickListener(new OnChildViewClickListener(onChildClickListener, getLayoutPosition(), id));
        }
        return this;
    }

    public TextView getTextView(int viewId) {
        return getView(viewId);
    }

    public Button getButton(int viewId) {
        return getView(viewId);
    }

    public ImageView getImageView(int viewId) {
        return getView(viewId);
    }

    public LinearLayout getLinearLayout(int viewId) {
        return getView(viewId);
    }

    public RelativeLayout getRelativeLayout(int viewId) {
        return getView(viewId);
    }

    @SuppressWarnings("unchecked")
    public <T extends View> T getView(int viewId) {
        View view = views.get(viewId);
        if (view == null) {
            view = itemView.findViewById(viewId);
            views.put(viewId, view);
        }
        return (T) view;
    }
}