package cn.lsmya.rxkit.picker;

import android.app.Activity;
import android.database.Cursor;
import android.provider.MediaStore;

import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.rxkit.R;
import cn.lsmya.rxkit.picker.DirectoryBean.PhotoBean;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.schedulers.Schedulers;

import static android.provider.MediaStore.Images.ImageColumns.BUCKET_DISPLAY_NAME;
import static android.provider.MediaStore.MediaColumns.DATA;
import static android.provider.MediaStore.MediaColumns.DATE_ADDED;
import static android.provider.MediaStore.MediaColumns.SIZE;

;
public class PhotoUtil {

    private static ArrayList<String> list;

    public static void getData(final Activity activity, final PhotosResultCallback callback) {
        final List<PhotoBean> list = new ArrayList<>();
        final List<DirectoryBean> dirList = new ArrayList<DirectoryBean>() {
            @Override
            public int indexOf(@Nullable Object o) {
                if (o instanceof DirectoryBean) {
                    DirectoryBean bean = (DirectoryBean) o;
                    for (int i = 0; i < this.size(); i++) {
                        DirectoryBean directory = get(i);
                        if (directory.getName().equals(bean.getName())) {
                            return i;
                        }
                    }
                    return -1;
                }
                return super.indexOf(o);
            }
        };
        Observable.create(new ObservableOnSubscribe<PhotoBean>() {

            @Override
            public void subscribe(ObservableEmitter<PhotoBean> emitter) throws Exception {
                Cursor cursor = activity.getContentResolver().query(
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
                while (cursor.moveToNext()) {
                    try {
                        String pName = cursor.getString(cursor.getColumnIndex(BUCKET_DISPLAY_NAME));
                        long time = cursor.getLong(cursor.getColumnIndex(DATE_ADDED));
                        long size = cursor.getLong(cursor.getColumnIndex(SIZE));
                        String path = cursor.getString(cursor.getColumnIndex(DATA));
                        if (size > 0) {
                            PhotoBean photoBean = new PhotoBean();
                            photoBean.setCreateTime(time);
                            photoBean.setPath(path);
                            photoBean.setDirectory(pName);
                            list.add(photoBean);
                            DirectoryBean directory = new DirectoryBean();
                            directory.setName(pName);
                            int indexOf = dirList.indexOf(directory);
                            if (indexOf == -1) {
                                directory.addPhoto(photoBean);
                                dirList.add(directory);
                            } else {
                                dirList.get(indexOf).addPhoto(photoBean);
                            }
                        }
                    } catch (Exception e) {

                    }
                }
                DirectoryBean directoryBean = new DirectoryBean();
                directoryBean.setName(activity.getString(R.string.rxkit_allPhoto));
                for (PhotoBean photo : list) {
                    photo.setDirectory(activity.getString(R.string.rxkit_allPhoto));
                    directoryBean.addPhoto(photo);
                }
                dirList.add(0, directoryBean);
                emitter.onComplete();
            }
        }).observeOn(AndroidSchedulers.mainThread())
                .subscribeOn(Schedulers.io())
                .subscribe(new Observer<PhotoBean>() {

                    @Override
                    public void onSubscribe(Disposable d) {
                        list.clear();
                    }

                    @Override
                    public void onNext(PhotoBean quiPhoto) {
                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onComplete() {
                        if (callback != null) {
                            callback.onResultCallback(dirList);
                        }
                    }
                });
    }
    public interface PhotosResultCallback {
        void onResultCallback(List<DirectoryBean> directories);
    }

    public static void add(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.add(path);
    }

    public static void delete(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.remove(path);
    }
    public static boolean contains(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        return list.contains(path);
    }
    public static void clear(){
        if (list == null) {
            list = new ArrayList<>();
        }
        list.clear();
    }

    public static ArrayList<String> getList() {
        if (list == null){
            list = new ArrayList<>();
        }
        return list;
    }
}
