package cn.lsmya.rxkit.picker;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.rxkit.R;
import cn.lsmya.rxkit.dialog.RxDialogBottomWidthByView;
import cn.lsmya.rxkit.view.recyclerview.RxBaseViewAdapter;
import cn.lsmya.rxkit.view.recyclerview.RxDefaultItemAnimator;
import cn.lsmya.rxkit.view.recyclerview.RxViewHolder;
import cn.lsmya.rxkit.picker.DirectoryBean.PhotoBean;

public class AlbumActivity extends AppCompatActivity implements RxBaseViewAdapter.OnChildClickListener, RxBaseViewAdapter.OnItemClickListener {

    private RecyclerView recyclerView;
    private TextView folderClick;
    private RxBaseViewAdapter<PhotoBean> adapter;
    private List<PhotoBean> list;

    private boolean single = true;
    private int maxSize = 15;

    private List<DirectoryBean> allPhoto;

    private static RxPickerCallback mCallback;

    private RequestOptions options;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.rxkit_activity_album);
        setTitle(getString(R.string.rxkit_select_photo));
        ActionBar supportActionBar = getSupportActionBar();
        supportActionBar.setDisplayHomeAsUpEnabled(true);
        options = new RequestOptions()
                .centerCrop()
                .skipMemoryCache(true)
                .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);

        single = getIntent().getBooleanExtra("single", true);
        recyclerView = findViewById(R.id.rxkit_album_recyclerView);
        folderClick = findViewById(R.id.rxkit_album_folder);
        folderClick.setOnClickListener(folderListener);
        if (single) {
            maxSize = 1;
        } else {
            maxSize = getIntent().getIntExtra("maxSize", 15);
        }
        list = new ArrayList<>();
        allPhoto = new ArrayList<>();
        PhotoUtil.clear();
        recyclerView.setItemAnimator(new RxDefaultItemAnimator());

        recyclerView.setLayoutManager(new GridLayoutManager(this, 3));
        adapter = new RxBaseViewAdapter<PhotoBean>(list, R.layout.rxkit_album_item, this) {
            @Override
            public void onBind(PhotoBean bean, int position, RxViewHolder ho) {
                ho.setImage(R.id.rxkit_albumItem_status, PhotoUtil.contains(bean.getPath()) ? R.drawable.rxkit_check_green : R.drawable.rxkit_uncheck_green)
                        .setOnClick(R.id.rxkit_albumItem_status);
                Glide.with(getContext()).load(bean.getPath())
                        .centerCrop()
                        .thumbnail(0.1f)
                        .apply(options)
                        .into(ho.getImageView(R.id.rxkit_albumItem_image));
            }
        };
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(this);
        PhotoUtil.getData(this, new PhotoUtil.PhotosResultCallback() {
            @Override
            public void onResultCallback(List<DirectoryBean> directories) {
                allPhoto = directories;
                list.clear();
                list.addAll(directories.get(0).getList());
                adapter.notifyDataSetChanged();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.rxkit_album_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.rxkit_album_ok) {
            /**
             * 确定按钮
             */
            if (PhotoUtil.getList().size() != 0) {
                exitOk();
            }
            return true;
        } else if (item.getItemId() == R.id.rxkit_album_look) {
            /**
             * 预览按钮
             */
            if (PhotoUtil.getList().size() != 0) {
                startActivityForResult(new Intent(AlbumActivity.this, QUIPhotoGalleryActivity.class)
                                .putExtra("maxSize", maxSize)
                                .putExtra("single", single)
                                .putExtra("type", 0),
                        101);
            }
        } else if (item.getItemId() == android.R.id.home) {
            finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public static void setOnPickerCallback(RxPickerCallback callback) {
        mCallback = callback;
    }

    /**
     * 切换文件夹
     */
    private View.OnClickListener folderListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            showDirectoryDialog(allPhoto);
        }
    };

    private void showDirectoryDialog(final List<DirectoryBean> dirs) {
        View view = LayoutInflater.from(AlbumActivity.this).inflate(R.layout.rxkit_album_dialog, null);
        RecyclerView dialogList = view.findViewById(R.id.rxkit_albumDialog_recyclerView);

        String selected = folderClick.getText().toString();
        for (int i = 0; i < dirs.size(); i++) {
            dirs.get(i).setSelect(dirs.get(i).getName().equals(selected));
        }
        dialogList.setLayoutManager(new LinearLayoutManager(AlbumActivity.this));
        RxBaseViewAdapter<DirectoryBean> dirDialogAdapter = new RxBaseViewAdapter<DirectoryBean>(dirs, R.layout.rxkit_album_dialog_item) {
            @Override
            public void onBind(DirectoryBean bean, int position, RxViewHolder ho) {
                ho.setText(R.id.rxkit_albumDialogItem_name, bean.getName())
                        .setText(R.id.rxkit_albumDialogItem_size, String.format(getString(R.string.rxkit_zhang), bean.getList().size()))
                        .setVisibility(R.id.rxkit_albumDialogItem_status, bean.isSelect() ? View.VISIBLE : View.GONE);
                Glide.with(getContext()).load(bean.getList().get(0).getPath())
                        .centerCrop()
                        .thumbnail(0.1f)
                        .apply(options)
                        .into(ho.getImageView(R.id.rxkit_albumDialogItem_icon));
            }
        };
        dialogList.setAdapter(dirDialogAdapter);
        final RxDialogBottomWidthByView dialog = new RxDialogBottomWidthByView(AlbumActivity.this, view);
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
        dirDialogAdapter.setOnItemClickListener(new RxBaseViewAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(int position) {
                DirectoryBean directory = dirs.get(position);
                folderClick.setText(directory.getName());
                list.clear();
                list.addAll(directory.getList());
                adapter.notifyDataSetChanged();
                dialog.cancel();
            }
        });

    }

    @Override
    public void onChildClick(int position, int id) {
        String path = list.get(position).getPath();
        if (id == R.id.rxkit_albumItem_status) {
            if (single) {
                boolean contains = PhotoUtil.contains(path);
                if (contains) {
                    PhotoUtil.delete(path);
                } else {
                    for (int i = 0; i < list.size(); i++) {
                        boolean has = PhotoUtil.contains(list.get(i).getPath());
                        if (has) {
                            PhotoUtil.delete(list.get(i).getPath());
                            adapter.notifyItemChanged(i);
                        }
                    }
                    PhotoUtil.clear();
                    PhotoUtil.add(path);
                }
                adapter.notifyItemChanged(position);
            } else {
                //多选
                boolean contains = PhotoUtil.contains(path);
                if (contains) {
                    PhotoUtil.delete(path);
                    adapter.notifyItemChanged(position);
                } else {
                    if (PhotoUtil.getList().size() < maxSize) {
                        PhotoUtil.add(path);
                        adapter.notifyItemChanged(position);
                    } else {
                        Toast.makeText(this, String.format(getString(R.string.rxkit_max_toast), maxSize), Toast.LENGTH_SHORT).show();
                    }
                }
            }
        }
    }

    /**
     * 点击查看大图
     *
     * @param position
     */
    @Override
    public void onItemClick(int position) {
        startActivityForResult(new Intent(this, QUIPhotoGalleryActivity.class)
                        .putExtra("directory", folderClick.getText().toString())
                        .putExtra("position", position)
                        .putExtra("single", single)
                        .putExtra("maxSize", maxSize)
                        .putExtra("type", 1),
                101);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101) {
            if (resultCode == RESULT_OK) {
                exitOk();
            } else {
                adapter.notifyDataSetChanged();
            }
        }
    }

    private void exitOk() {
        ArrayList<String> list = PhotoUtil.getList();
        if (mCallback != null) {
            mCallback.onCallback(list);
        }
        setOnPickerCallback(null);
        finish();
    }
}
