package cn.lsmya.rxkit.permission;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.os.Build;

import androidx.core.content.ContextCompat;

/**
 * 权限申请工具类
 */
public class RxEasyPermission {
    private Activity mActivity;
    private OnPermissionListener mOnPermissionListener;

    private String[] mPermissions;

    public RxEasyPermission(Activity mActivity) {
        this.mActivity = mActivity;
    }

    /**
     * 初始化
     * @param activity 当前activity
     * @return 返回EasyPermission
     */
    public static RxEasyPermission init(Activity activity) {
        return new RxEasyPermission(activity);
    }

    /**
     * 添加权限
     * @param permission 需要申请的权限
     * @return 返回EasyPermission
     */
    public RxEasyPermission permission(String... permission) {
        mPermissions = permission;
        return this;
    }

    /**
     * 开始申请权限
     * @param onPermissionListener 权限申请监听
     */
    public void builder(OnPermissionListener onPermissionListener) {
        mOnPermissionListener = onPermissionListener;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            request23ToActivity();
        } else {
            mOnPermissionListener.onYes();
        }
    }

    /**
     * sdk23以上申请权限
     */
    private void request23ToActivity() {
        if (checkPermission()) {
            PermissionFragment.getInstance(mPermissions).request(mActivity, mOnPermissionListener);
        } else {
            mOnPermissionListener.onYes();
        }
    }

    /**
     * 检查权限
     * @return true:需要申请；false:已申请
     */
    private boolean checkPermission() {
        for (int i = 0; i < mPermissions.length; i++) {
            if (ContextCompat.checkSelfPermission(mActivity, mPermissions[i]) != PackageManager.PERMISSION_GRANTED) {
                return true;
            }
        }
        return false;
    }
}
