package cn.lsmya.rxkit

import android.util.Log

/**
 * 日志工具类
 */
class RxLog private constructor() {
    companion object {
        private var mDebug = true
        private const val mTag = "【 日志 】"

        @JvmStatic
        fun init(debug: Boolean) {
            mDebug = debug
        }

        @JvmStatic
        fun d(msg: String) {
            if (mDebug) {
                d(mTag, msg)
            }
        }

        @JvmStatic
        fun e(msg: String) {
            if (mDebug) {
                e(mTag, msg)
            }
        }

        @JvmStatic
        fun i(msg: String) {
            if (mDebug) {
                i(mTag, msg)
            }
        }

        @JvmStatic
        fun v(msg: String) {
            if (mDebug) {
                v(mTag, msg)
            }
        }

        @JvmStatic
        fun d(tag: String, msg: String) {
            if (mDebug) {
                Log.d(tag, msg)
            }
        }

        @JvmStatic
        fun e(tag: String, msg: String) {
            if (mDebug) {
                Log.e(tag, msg)
            }
        }

        @JvmStatic
        fun i(tag: String, msg: String) {
            if (mDebug) {
                Log.i(tag, msg)
            }
        }

        @JvmStatic
        fun v(tag: String, msg: String) {
            if (mDebug) {
                Log.v(tag, msg)
            }
        }

    }
}