package cn.lsmya.imagepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

import cn.lsmya.imagepicker.bean.DirectoryBean;
import cn.lsmya.imagepicker.R;

public class DirectoryDialogAdapter extends RecyclerView.Adapter<DirectoryDialogAdapter.ViewHolder> {
    private Context context;
    private List<DirectoryBean> list;
    private RequestOptions options;
    /**
     * item点击监听
     */
    private OnItemClickListener onItemClickListener;
    private RecyclerView recyclerView;

    public DirectoryDialogAdapter(Context context, List<DirectoryBean> list) {
        this.context = context;
        this.list = list;
        options = new RequestOptions()
                .centerCrop()
                .skipMemoryCache(true)
                .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);

    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        View view = LayoutInflater.from(recyclerView.getContext()).inflate(R.layout.kit_album_dialog_item, parent, false);
        final ViewHolder viewHolder = new ViewHolder(view);
        if (onItemClickListener != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.onItemClick(viewHolder.getLayoutPosition());
                }
            });
        }
        return viewHolder;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        DirectoryBean bean = list.get(position);
        holder.nameView.setText(bean.getName());
        holder.numberView.setText(String.format(context.getString(R.string.kit_zhang), bean.getList().size()));
        holder.statusView.setVisibility(bean.isSelect() ? View.VISIBLE : View.GONE);
        try {
            Glide.with(context).load(bean.getList().get(0).getPath())
                    .centerCrop()
                    .thumbnail(0.1f)
                    .apply(options)
                    .into(holder.imageView);
        } catch (Exception e) {
            holder.imageView.setImageResource(R.drawable.kit_error_image);
        }

    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private TextView nameView;
        private TextView numberView;
        private ImageView statusView;
        private ImageView imageView;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            nameView = itemView.findViewById(R.id.kit_albumDialogItem_name);
            numberView = itemView.findViewById(R.id.kit_albumDialogItem_size);
            statusView = itemView.findViewById(R.id.kit_albumDialogItem_status);
            imageView = itemView.findViewById(R.id.kit_albumDialogItem_icon);
        }
    }

    /**
     * item的点击事件
     *
     * @param onItemClickListener 回调监听
     */
    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    /**
     * item点击事件回调
     */
    public interface OnItemClickListener {
        void onItemClick(int position);
    }

}
