package cn.lsmya.imagepicker;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;

import java.util.ArrayList;

public class RxImagePicker implements Handler.Callback {

    private Context mContext;
    /**
     * 可以选择的图片数目
     */
    private int DEFAULT_PICK_SIZE = 9;
    private int mTheme = R.style.helper_themeNotBar;

    private RxPickerCallback mCallback;

    public RxImagePicker(Context context) {
        mContext = context;
    }

    public RxImagePicker setMaxPickSize(int size) {
        DEFAULT_PICK_SIZE = size;
        return this;
    }

    public RxImagePicker setTheme(int theme) {
        mTheme = theme;
        return this;
    }

    public void build(RxPickerCallback callback) {
        this.mCallback = callback;
        Intent intent = new Intent(mContext, AlbumActivity.class);
        intent.putExtra("theme", mTheme);
        intent.putExtra("maxSize", DEFAULT_PICK_SIZE);
        mContext.startActivity(intent);
    }

    public static void showBigImage(Context context, String... image) {
        ArrayList<String> list = new ArrayList<>();
        for (String s : image) {
            list.add(s);
        }
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));
    }

    public static void showBigImage(Context context, ArrayList<String> list) {
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));
    }

    private static RxImagePicker instance;

    private final Handler mHandler = new Handler(Looper.getMainLooper(), this);

    void send(int what, ArrayList<String> object) {
        mHandler.sendMessage(mHandler.obtainMessage(what, object));
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (mCallback != null) {
            synchronized (mCallback) {
                mCallback.onCallback((ArrayList<String>) msg.obj);
                instance = null;
            }
        }
        return true;
    }

    public static RxImagePicker newBuilder(Context context) {
        if (instance == null) {
            synchronized (RxImagePicker.class) {
                if (instance == null) {
                    instance = new RxImagePicker(context);
                }
            }
        }
        return instance;
    }
}
