package cn.lsmya.imagepicker;

import android.app.Dialog;
import android.content.Intent;
import android.os.Bundle;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.imagepicker.adapter.AlbumAdapter;
import cn.lsmya.imagepicker.adapter.DirectoryDialogAdapter;
import cn.lsmya.imagepicker.bean.DirectoryBean;

public class AlbumActivity extends AppCompatActivity implements AlbumAdapter.OnChildClickListener, AlbumAdapter.OnItemClickListener {

    private TextView folderClick;
    private AlbumAdapter adapter;
    private List<DirectoryBean.PhotoBean> list;

    private int maxSize = 15;

    private List<DirectoryBean> allPhoto;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setTheme(getIntent().getIntExtra("theme", R.style.helper_themeNotBar));
        setContentView(R.layout.kit_activity_album);
        setTitle(getString(R.string.kit_select_photo));
        Toolbar toolbar = findViewById(R.id.kit_album_toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        RecyclerView recyclerView = findViewById(R.id.kit_album_recyclerView);
        folderClick = findViewById(R.id.kit_album_folder);
        folderClick.setOnClickListener(folderListener);
        maxSize = getIntent().getIntExtra("maxSize", 15);
        list = new ArrayList<>();
        allPhoto = new ArrayList<>();
        PhotoUtil.clear();
        recyclerView.setItemAnimator(new DefaultItemAnimator());

        recyclerView.setLayoutManager(new GridLayoutManager(this, 3));
        adapter = new AlbumAdapter(this, list, this);
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(this);
        PhotoUtil.getData(this, new PhotoUtil.PhotosResultCallback() {
            @Override
            public void onResultCallback(List<DirectoryBean> directories) {
                allPhoto = directories;
                list.clear();
                list.addAll(directories.get(0).getList());
                adapter.notifyDataSetChanged();
            }
        });
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.kit_album_menu, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.kit_album_ok) {
            /**
             * 确定按钮
             */
            if (PhotoUtil.getList().size() != 0) {
                exitOk();
            }
            return true;
        } else if (item.getItemId() == R.id.kit_album_look) {
            /**
             * 预览按钮
             */
            if (PhotoUtil.getList().size() != 0) {
                startActivityForResult(new Intent(AlbumActivity.this, PhotoGalleryActivity.class)
                                .putExtra("theme", getIntent().getIntExtra("theme", R.style.helper_themeNotBar))
                                .putExtra("maxSize", maxSize)
                                .putExtra("type", 0),
                        101);
            }
        } else if (item.getItemId() == android.R.id.home) {
            finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    /**
     * 切换文件夹
     */
    private View.OnClickListener folderListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            showDirectoryDialog(allPhoto);
        }
    };

    private void showDirectoryDialog(final List<DirectoryBean> dirs) {
        View view = LayoutInflater.from(AlbumActivity.this).inflate(R.layout.kit_album_dialog, null);
        RecyclerView dialogList = view.findViewById(R.id.kit_albumDialog_recyclerView);

        String selected = folderClick.getText().toString();
        for (int i = 0; i < dirs.size(); i++) {
            dirs.get(i).setSelect(dirs.get(i).getName().equals(selected));
        }
        dialogList.setLayoutManager(new LinearLayoutManager(AlbumActivity.this));
        DirectoryDialogAdapter dirDialogAdapter = new DirectoryDialogAdapter(this, dirs);
        dialogList.setAdapter(dirDialogAdapter);

        final Dialog dialog = new Dialog(AlbumActivity.this, R.style.DialogTheme);
        dialog.setContentView(view);
        dialog.setCanceledOnTouchOutside(false);

        Window window = dialog.getWindow();
        //设置弹出位置
        window.setGravity(Gravity.BOTTOM);
        //设置弹出动画
        window.setWindowAnimations(R.style.main_menu_animStyle);
        //设置对话框大小
        window.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);

        dialog.show();

        dirDialogAdapter.setOnItemClickListener(new DirectoryDialogAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(int position) {
                DirectoryBean directory = dirs.get(position);
                folderClick.setText(directory.getName());
                list.clear();
                list.addAll(directory.getList());
                adapter.notifyDataSetChanged();
                dialog.cancel();
            }
        });

    }

    @Override
    public void onChildClick(int position, int id) {
        String path = list.get(position).getPath();
        if (id == R.id.kit_albumItem_status) {
            boolean contains = PhotoUtil.contains(path);
            if (contains) {
                PhotoUtil.delete(path);
                adapter.notifyItemChanged(position);
            } else {
                if (PhotoUtil.getList().size() < maxSize) {
                    PhotoUtil.add(path);
                    adapter.notifyItemChanged(position);
                } else {
                    Toast.makeText(this, String.format(getString(R.string.kit_max_toast), maxSize), Toast.LENGTH_SHORT).show();
                }
            }
        }
    }

    /**
     * 点击查看大图
     *
     * @param position
     */
    @Override
    public void onItemClick(int position) {
        startActivityForResult(new Intent(this, PhotoGalleryActivity.class)
                        .putExtra("theme", getIntent().getIntExtra("theme", R.style.helper_themeNotBar))
                        .putExtra("directory", folderClick.getText().toString())
                        .putExtra("position", position)
                        .putExtra("maxSize", maxSize)
                        .putExtra("type", 1),
                101);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 101) {
            if (resultCode == RESULT_OK) {
                exitOk();
            } else {
                adapter.notifyDataSetChanged();
            }
        }
    }

    private void exitOk() {
        ArrayList<String> list = PhotoUtil.getList();
        RxImagePicker.newBuilder(this)
                .send(1, list);
        finish();
    }
}
