package cn.lsmya.imagepicker;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;

import java.util.ArrayList;

public class RxImagePicker implements Handler.Callback {

    private Context mContext;
    /**
     * 是否单选单选模式
     */
    private boolean SINGLE_PICK = false;
    /**
     * 可以选择的图片数目
     */
    private int DEFAULT_PICK_SIZE = 9;

    private RxPickerCallback mCallback;

    public RxImagePicker(Context context) {
        mContext = context;
    }

    public RxImagePicker setMaxPickSize(int size) {
        DEFAULT_PICK_SIZE = size;
        return this;
    }

    public RxImagePicker openSinglePick() {
        return setSinglePick(true);
    }

    public RxImagePicker setSinglePick(boolean singlePick) {
        SINGLE_PICK = singlePick;
        return this;
    }

    public void build(RxPickerCallback callback) {
        this.mCallback = callback;
        Intent intent = new Intent(mContext, AlbumActivity.class);
        intent.putExtra("single", SINGLE_PICK);
        intent.putExtra("maxSize", SINGLE_PICK ? 1 : DEFAULT_PICK_SIZE);
        mContext.startActivity(intent);
    }

    public static void showBigImage(Context context, String... image) {
        ArrayList<String> list = new ArrayList<>();
        for (String s : image) {
            list.add(s);
        }
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));
    }

    public static void showBigImage(Context context, ArrayList<String> list) {
        context.startActivity(new Intent(context, ImageBigActivity.class)
                .putStringArrayListExtra("list", list));

    }

    private static RxImagePicker instance;

    private final Handler mHandler = new Handler(Looper.getMainLooper(), this);

    void send(int what, ArrayList<String> object) {
        mHandler.sendMessage(mHandler.obtainMessage(what, object));
    }

    @Override
    public boolean handleMessage(Message msg) {
        if (mCallback != null) {
            synchronized (mCallback) {
                mCallback.onCallback((ArrayList<String>) msg.obj);
            }
        }
        return true;
    }

    public static RxImagePicker newBuilder(Context context) {
      return newBuilder(context,R.style.helper_theme);
    }
    public static RxImagePicker newBuilder(Context context,int style) {
        if (instance == null) {
            synchronized (RxImagePicker.class) {
                if (instance == null) {
                    instance = new RxImagePicker(context);
                }
            }
        }
        return instance;
    }
}
