package cn.lsmya.imagepicker;

import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;

import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.imagepicker.adapter.ImageBigAdapter;


public class ImageBigActivity extends AppCompatActivity implements ImageBigAdapter.OnItemClickListener {

    private RecyclerView recyclerView;
    private ImageBigAdapter adapter;
    private List<String> list;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.kit_activity_image_big);
        setTitle(getString(R.string.kit_look_big));
        list = new ArrayList<>();

        ActionBar supportActionBar = getSupportActionBar();
        supportActionBar.setDisplayHomeAsUpEnabled(true);
        recyclerView = findViewById(R.id.kit_imageBig_recyclerView);
        final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
        linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
        recyclerView.setLayoutManager(linearLayoutManager);
        adapter = new ImageBigAdapter(this,list);
        recyclerView.setAdapter(adapter);
        adapter.setOnItemClickListener(this);
        PagerSnapHelper snapHelper = new PagerSnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(new RecyclerViewPageChangeListener(snapHelper, new OnPageChangeListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {

            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {

            }

            @Override
            public void onPageSelected(int pos) {
                if (list.size() != 1) {
                    setTitle(String.format(getString(R.string.kit_look_big_num), pos + 1, list.size()));
                }
            }
        }));
        ArrayList<String> strings = getIntent().getStringArrayListExtra("list");
        if (strings != null && strings.size() != 0) {
            list.clear();
            list.addAll(strings);
            adapter.notifyDataSetChanged();
            if (list.size() != 1) {
                setTitle(String.format(getString(R.string.kit_look_big_num), 1, list.size()));

            }
        }
    }

    @Override
    public void onItemClick(int position) {
        finish();
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                break;
            default:
                break;
        }
        return super.onOptionsItemSelected(item);

    }
    class RecyclerViewPageChangeListener extends RecyclerView.OnScrollListener {
        private SnapHelper snapHelper;
        private OnPageChangeListener onPageChangeListener;
        private int oldPosition = -1;

        public RecyclerViewPageChangeListener(SnapHelper snapHelper, OnPageChangeListener onPageChangeListener) {
            this.snapHelper = snapHelper;
            this.onPageChangeListener = onPageChangeListener;
        }

        @Override
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (onPageChangeListener != null) {
                onPageChangeListener.onScrolled(recyclerView, dx, dy);
            }
        }

        @Override
        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            int position = 0;
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            //获取当前选中的itemView
            View view = snapHelper.findSnapView(layoutManager);
            if (view != null) {
                //获取itemView的position
                position = layoutManager.getPosition(view);
            }
            if (onPageChangeListener != null) {
                onPageChangeListener.onScrollStateChanged(recyclerView, newState);
                //newState == RecyclerView.SCROLL_STATE_IDLE 当滚动停止时触发防止在滚动过程中不停触发
                if (newState == RecyclerView.SCROLL_STATE_IDLE && oldPosition != position) {
                    oldPosition = position;
                    onPageChangeListener.onPageSelected(position);
                }
            }
        }


    }
     interface OnPageChangeListener {
        void onScrollStateChanged(RecyclerView recyclerView, int newState);

        void onScrolled(RecyclerView recyclerView, int dx, int dy);

        void onPageSelected(int position);
    }

}
