package cn.lsmya.imagepicker.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.RequestOptions;

import java.util.List;

import cn.lsmya.imagepicker.bean.DirectoryBean;
import cn.lsmya.imagepicker.R;

public class GalleryAdapter extends RecyclerView.Adapter<GalleryAdapter.ViewHolder> {
    private Context context;
    private List<DirectoryBean.PhotoBean> list;
    private RequestOptions options;
    /**
     * item点击监听
     */
    private OnItemClickListener onItemClickListener;
    private RecyclerView recyclerView;

    public GalleryAdapter(Context context, List<DirectoryBean.PhotoBean> list) {
        this.context = context;
        this.list = list;
        options = new RequestOptions()
                .fitCenter()
                .skipMemoryCache(true)
                .diskCacheStrategy(DiskCacheStrategy.AUTOMATIC);
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {

        View view = LayoutInflater.from(recyclerView.getContext()).inflate(R.layout.kit_photo_gallery_item, parent, false);
        final ViewHolder viewHolder = new ViewHolder(view);
        if (onItemClickListener != null) {
            viewHolder.itemView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    onItemClickListener.onItemClick(viewHolder.getLayoutPosition());
                }
            });
        }
        return viewHolder;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, final int position) {
        Glide.with(context).load(list.get(position).getPath())
                .thumbnail(0.1f)
                .apply(options)
                .into(holder.imageView);
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    public class ViewHolder extends RecyclerView.ViewHolder {
        private ImageView imageView;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            imageView = itemView.findViewById(R.id.kit_photoGalleryItem_image);
        }
    }

    /**
     * item的点击事件
     *
     * @param onItemClickListener 回调监听
     */
    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.onItemClickListener = onItemClickListener;
    }

    /**
     * item点击事件回调
     */
    public interface OnItemClickListener {
        void onItemClick(int position);
    }

}
