package cn.lsmya.imagepicker;

import android.app.Activity;
import android.database.Cursor;
import android.provider.MediaStore;
import android.util.Log;

import androidx.annotation.Nullable;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.imagepicker.bean.DirectoryBean;

import static android.provider.MediaStore.Images.ImageColumns.BUCKET_DISPLAY_NAME;

public class PhotoUtil {

    private static ArrayList<String> list;

    public static void getData(final Activity activity, final PhotosResultCallback callback) {

        final List<DirectoryBean.PhotoBean> list = new ArrayList<>();
        final List<DirectoryBean> dirList = new ArrayList<DirectoryBean>() {
            @Override
            public int indexOf(@Nullable Object o) {
                if (o instanceof DirectoryBean) {
                    DirectoryBean bean = (DirectoryBean) o;
                    for (int i = 0; i < this.size(); i++) {
                        DirectoryBean directory = get(i);
                        if (directory.getName().equals(bean.getName())) {
                            return i;
                        }
                    }
                    return -1;
                }
                return super.indexOf(o);
            }
        };
        list.clear();

        new Thread(){
            @Override
            public void run() {
                super.run();

                Cursor cursor = activity.getContentResolver().query(
                        MediaStore.Images.Media.EXTERNAL_CONTENT_URI, null, null, null, null);
                while (cursor.moveToNext()) {
                    try {
                        String pName = cursor.getString(cursor.getColumnIndex(BUCKET_DISPLAY_NAME));
                        long size = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.SIZE));
                        long time = cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media.DATE_ADDED));
                        String path = cursor.getString(cursor.getColumnIndex(MediaStore.Images.ImageColumns.DATA));
                        if (size > 0) {
                            DirectoryBean.PhotoBean photoBean = new DirectoryBean.PhotoBean();
                            photoBean.setCreateTime(time);
                            photoBean.setPath(path);
                            photoBean.setDirectory(pName);
                            list.add(0, photoBean);
                            DirectoryBean directory = new DirectoryBean();
                            directory.setName(pName);
                            int indexOf = dirList.indexOf(directory);
                            if (indexOf == -1) {
                                directory.addPhoto(photoBean);
                                dirList.add(0, directory);
                            } else {
                                dirList.get(indexOf).addPhoto(photoBean);
                            }
                        }
                    } catch (Exception e) {
                        Log.e("异常", e.getMessage());
                    }
                }
                DirectoryBean directoryBean = new DirectoryBean();
                directoryBean.setName(activity.getString(R.string.kit_allPhoto));
                for (DirectoryBean.PhotoBean photo : list) {
                    photo.setDirectory(activity.getString(R.string.kit_allPhoto));
                    directoryBean.addPhoto(photo);
                }
                dirList.add(0, directoryBean);
                activity.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (callback != null) {
                            callback.onResultCallback(dirList);
                        }
                    }
                });
            }
        }.start();
    }

    public interface PhotosResultCallback {
        void onResultCallback(List<DirectoryBean> directories);
    }

    public static void add(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.add(path);
    }

    public static void delete(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.remove(path);
    }

    public static boolean contains(String path) {
        if (list == null) {
            list = new ArrayList<>();
        }
        return list.contains(path);
    }

    public static void clear() {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.clear();
    }

    public static ArrayList<String> getList() {
        if (list == null) {
            list = new ArrayList<>();
        }
        return list;
    }
}
