package cn.lsmya.imagepicker;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.widget.CheckBox;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;

import java.util.ArrayList;
import java.util.List;

import cn.lsmya.imagepicker.adapter.GalleryAdapter;
import cn.lsmya.imagepicker.adapter.LookAdapter;
import cn.lsmya.imagepicker.bean.DirectoryBean;

public class PhotoGalleryActivity extends AppCompatActivity implements GalleryAdapter.OnItemClickListener, View.OnClickListener, LookAdapter.OnItemClickListener {

    public Toolbar toolbar;
    private RecyclerView recyclerView;
    public CheckBox checkBox;
    private View statusLayout;

    private String directory;
    private int position = 0;
    private int maxSize;
    private boolean single;
    private List<DirectoryBean.PhotoBean> list;
    private List<String> listLook;

    private GalleryAdapter adapter;
    private LookAdapter adapterLook;

    private boolean showBar = true;
    /**
     * 打开类型
     * 0：预览
     * 1：查看大图
     */
    private int type = -1;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        transparencyBar();
        setContentView(R.layout.kit_activity_photo_gallery);
        type = getIntent().getIntExtra("type", -1);
        if (type < 0) {
            Toast.makeText(this, getString(R.string.kit_open_exception), Toast.LENGTH_SHORT).show();
            finish();
        } else {
            directory = getIntent().getStringExtra("directory");
            position = getIntent().getIntExtra("position", 0);
            maxSize = getIntent().getIntExtra("maxSize", 15);
            single = getIntent().getBooleanExtra("single", true);
            list = new ArrayList<>();
            listLook = new ArrayList<>();
            toolbar = findViewById(R.id.kit_photoGallery_toolbar);
            recyclerView = findViewById(R.id.kit_photoGallery_recyclerView);
            checkBox = findViewById(R.id.kit_photoGallery_status);
            statusLayout = findViewById(R.id.kit_photoGallery_statusLayout);

            toolbar.setBackgroundColor(ContextCompat.getColor(this, R.color.kit_colorAccent));
            setSupportActionBar(toolbar);

            int height = toolbar.getLayoutParams().height;
            int statusBarHeight = getStatusBarHeight(this);
            toolbar.getLayoutParams().height = height + statusBarHeight;
            toolbar.setPadding(0, statusBarHeight, 0, 0);


            final LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this);
            linearLayoutManager.setOrientation(LinearLayoutManager.HORIZONTAL);
            recyclerView.setLayoutManager(linearLayoutManager);

            checkBox.setOnClickListener(this);
            if (type == 0) {
                adapterLook = new LookAdapter(PhotoGalleryActivity.this,listLook);
                recyclerView.setAdapter(adapterLook);
                adapterLook.setOnItemClickListener(this);
                listLook.addAll(PhotoUtil.getList());
                adapterLook.notifyDataSetChanged();
                String path = listLook.get(position);
                boolean contains = PhotoUtil.contains(path);
                checkBox.setChecked(contains);
                new Handler().postAtTime(new Runnable() {
                    @Override
                    public void run() {
                        toolbar.setTitle(String.format(getString(R.string.kit_title_num), position + 1, listLook.size()));
                    }
                }, 10);
                refreshMenu();
            } else if (type == 1) {
                adapter = new GalleryAdapter(PhotoGalleryActivity.this,list);
                recyclerView.setAdapter(adapter);
                adapter.setOnItemClickListener(this);

                PhotoUtil.getData(this, new PhotoUtil.PhotosResultCallback() {
                    @Override
                    public void onResultCallback(List<DirectoryBean> directories) {
                        for (DirectoryBean directoryBean : directories) {
                            if (directoryBean.getName().equals(directory)) {
                                list.clear();
                                list.addAll(directoryBean.getList());
                                adapter.notifyDataSetChanged();
                                linearLayoutManager.scrollToPositionWithOffset(position, 0);
                                linearLayoutManager.setStackFromEnd(true);
                                String path = list.get(position).getPath();
                                boolean contains = PhotoUtil.contains(path);
                                checkBox.setChecked(contains);
                                toolbar.setTitle(String.format(getString(R.string.kit_title_num), position + 1, list.size()));
                                refreshMenu();
                            }
                        }
                    }
                });
            }
            initPagerSnapHelper();
        }
    }

    private void initPagerSnapHelper() {
        PagerSnapHelper snapHelper = new PagerSnapHelper();
        snapHelper.attachToRecyclerView(recyclerView);
        recyclerView.addOnScrollListener(new RecyclerViewPageChangeListener(snapHelper, new OnPageChangeListener() {
            @Override
            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {

            }

            @Override
            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {

            }

            @Override
            public void onPageSelected(int pos) {
                position = pos;
                if (type == 0) {
                    String path = listLook.get(position);
                    boolean contains = PhotoUtil.contains(path);
                    checkBox.setChecked(contains);
                    toolbar.setTitle(String.format(getString(R.string.kit_title_num), position + 1, listLook.size()));
                } else if (type == 1) {
                    String path = list.get(position).getPath();
                    boolean contains = PhotoUtil.contains(path);
                    checkBox.setChecked(contains);
                    toolbar.setTitle(String.format(getString(R.string.kit_title_num), position + 1, list.size()));

                }
                refreshMenu();
            }
        }));
    }

    MenuItem menuItem;

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        getMenuInflater().inflate(R.menu.kit_menu, menu);
        menuItem = menu.findItem(R.id.kit_menu_ok);
        refreshMenu();
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.kit_menu_ok) {
            /**
             * 确定按钮
             */
            if (PhotoUtil.getList().size() != 0) {
                setResult(RESULT_OK);
                finish();
            }
            return true;
        } else if (item.getItemId() == android.R.id.home) {
            finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void refreshMenu() {
        try {
            if (PhotoUtil.getList().size() == 0) {
                menuItem.setTitle(getString(R.string.kit_ensure));
            } else {
                menuItem.setTitle(String.format(getString(R.string.kit_ensure_num), PhotoUtil.getList().size(), maxSize));
            }
        } catch (Exception e) {
        }
    }

    @Override
    public void onItemClick(int pos) {
        if (showBar) {
            toolbar.animate().translationY(-toolbar.getHeight()).setInterpolator(new AccelerateInterpolator(2));
            statusLayout.animate().alpha(0.0f).setInterpolator(new AccelerateInterpolator(2));
        } else {
            toolbar.animate().translationY(0).setInterpolator(new DecelerateInterpolator(2));
            statusLayout.animate().alpha(1.0f).setInterpolator(new DecelerateInterpolator(2));
        }
        showBar = !showBar;
    }

    /**
     * 修改状态栏为全透明
     */
    @TargetApi(19)
    private void transparencyBar() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Window window = getWindow();
            window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            window.getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                    | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            window.setStatusBarColor(Color.TRANSPARENT);

        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            Window window = getWindow();
            window.setFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS,
                    WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        }
    }

    private int getStatusBarHeight(Context context) {
        int result = -1;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    @Override
    public void onClick(View v) {
        String path = "";
        if (type == 0) {
            path = listLook.get(position);
        } else if (type == 1) {
            path = list.get(position).getPath();
        }
        if (single) {
            boolean contains = PhotoUtil.contains(path);
            if (contains) {
                PhotoUtil.clear();
            } else {
                if (PhotoUtil.getList().size() < maxSize) {
                    PhotoUtil.add(path);
                } else {
                    checkBox.setChecked(false);
                    Toast.makeText(this, String.format(getString(R.string.kit_max_toast), maxSize), Toast.LENGTH_SHORT).show();
                }
            }
        } else {
            boolean contains = PhotoUtil.contains(path);
            if (contains) {
                PhotoUtil.delete(path);
            } else {
                if (PhotoUtil.getList().size() < maxSize) {
                    PhotoUtil.add(path);
                } else {
                    checkBox.setChecked(false);
                    Toast.makeText(this, String.format(getString(R.string.kit_max_toast), maxSize), Toast.LENGTH_SHORT).show();
                }
            }
        }
        refreshMenu();
    }
    class RecyclerViewPageChangeListener extends RecyclerView.OnScrollListener {
        private SnapHelper snapHelper;
        private OnPageChangeListener onPageChangeListener;
        private int oldPosition = -1;

        public RecyclerViewPageChangeListener(SnapHelper snapHelper, OnPageChangeListener onPageChangeListener) {
            this.snapHelper = snapHelper;
            this.onPageChangeListener = onPageChangeListener;
        }

        @Override
        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            super.onScrolled(recyclerView, dx, dy);
            if (onPageChangeListener != null) {
                onPageChangeListener.onScrolled(recyclerView, dx, dy);
            }
        }

        @Override
        public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
            super.onScrollStateChanged(recyclerView, newState);
            int position = 0;
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            //获取当前选中的itemView
            View view = snapHelper.findSnapView(layoutManager);
            if (view != null) {
                //获取itemView的position
                position = layoutManager.getPosition(view);
            }
            if (onPageChangeListener != null) {
                onPageChangeListener.onScrollStateChanged(recyclerView, newState);
                //newState == RecyclerView.SCROLL_STATE_IDLE 当滚动停止时触发防止在滚动过程中不停触发
                if (newState == RecyclerView.SCROLL_STATE_IDLE && oldPosition != position) {
                    oldPosition = position;
                    onPageChangeListener.onPageSelected(position);
                }
            }
        }


    }
    interface OnPageChangeListener {
        void onScrollStateChanged(RecyclerView recyclerView, int newState);

        void onScrolled(RecyclerView recyclerView, int dx, int dy);

        void onPageSelected(int position);
    }

}

