package cn.lsmya.http.other;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

import cn.lsmya.http.HttpManage;
import cn.lsmya.http.ProgressInterceptor;
import cn.lsmya.http.listener.OnProgressListener;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class HttpSender {

    /**
     * 连接、读写超时均为10s、添加信任证书并忽略host验证
     *
     * @return 返回默认的OkHttpClient对象
     */
    public static OkHttpClient getDefaultOkHttpClient() {
        return new OkHttpClient.Builder()
                .connectTimeout(10, TimeUnit.SECONDS)
                .readTimeout(10, TimeUnit.SECONDS)
                .writeTimeout(10, TimeUnit.SECONDS)
                .build();
    }

    /**
     * 用于下载的OkHttpClient
     */
    public static OkHttpClient getDownloadOkHttpClient(OnProgressListener progressCallback) {
        return HttpManage.getOkHttpClient().newBuilder()
                .addNetworkInterceptor(new ProgressInterceptor(progressCallback))
                .build();
    }

    /**
     * 下载文件请求
     *
     * @param request 请求参数
     * @return Http响应结果
     * @throws IOException 超时、网络异常
     */
    public static void download(OnProgressListener listener, Request request, final Callback callBack) {
        getDownloadOkHttpClient(listener).newCall(request).enqueue(callBack);
    }

    /**
     * 同步执行请求
     *
     * @param request 请求参数
     * @return Http响应结果
     * @throws IOException 超时、网络异常
     */
    public static void execute(Request request, final Callback callBack) {
        newCall(request).enqueue(callBack);
    }

    static Call newCall(Request request) {
        return newCall(HttpManage.getOkHttpClient(), request);
    }

    static Call newCall(OkHttpClient client, Request request) {
        return client.newCall(request);
    }

}







