package cn.lsmya.http.other;

import java.io.EOFException;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.TimeUnit;

import cn.lsmya.http.HttpManage;
import io.reactivex.annotations.NonNull;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;

public class HttpLogUtil {
    private static final String TAG = "HTTP";

    //请求前，打印日志
    public static void log(@NonNull Request request) {
        if (!HttpManage.getDebug()) {
            return;
        }
        try {
            String builder = "<------------------- request start Method=" +
                    request.method() + " ------------------->" +
                    request2Str(request) +
                    "\n<------------------- request start Method=" +
                    request.method() + " ------------------->";
            logd(TAG, builder);
        } catch (Exception e) {
            logd(TAG, "Request start log printing failed", e);
        }
    }

    //打印Http返回的正常结果
    public static void log(@NonNull Response response, String downloadPath) {
        if (!HttpManage.getDebug()) {
            return;
        }
        try {
            Request request = response.request();
            LogTime logTime = request.tag(LogTime.class);
            long tookMs = logTime != null ? logTime.tookMs() : 0;
            String result = downloadPath != null ? downloadPath : getResult(response.body());
            StringBuilder builder = new StringBuilder()
                    .append("<------------------- request end Method=").append(request.method())
                    .append(" Code=").append(response.code()).append(" ------------------->");
            if (tookMs > 0) {
                builder.append("(").append(tookMs).append("ms)");
            }
            builder.append("\n\n").append(getEncodedUrlAndParams(request))
                    .append("\n\n").append(response.headers())
                    .append("\n").append(result)
                    .append("\n<------------------- request end Method=").append(request.method())
                    .append(" Code=").append(response.code()).append(" ------------------->");
            logi(TAG, builder.toString());
        } catch (Exception e) {
            logd(TAG, "Request end Log printing failed", e);
        }
    }

    @SuppressWarnings("deprecation")
    public static String getEncodedUrlAndParams(Request request) {
        String result;
        try {
            result = getRequestParams(request);
        } catch (IOException e) {
            e.printStackTrace();
            result = request.url().toString();
        }
        try {
            return URLDecoder.decode(result);
        } catch (Exception e) {
            return result;
        }
    }

    private static String request2Str(Request request) {
        StringBuilder builder = new StringBuilder();
        builder.append("\n\n")
                .append(getEncodedUrlAndParams(request));
        RequestBody body = request.body();
        if (body != null) {
            builder.append("\n\nContent-Type: ").append(body.contentType());
            try {
                builder.append("\nContent-Length: ").append(body.contentLength());
            } catch (IOException ignore) {
            }
        }
        builder.append(body != null ? "\n" : "\n\n").append(request.headers());
        return builder.toString();
    }

    private static String getRequestParams(Request request) throws IOException {
        RequestBody body = request.body();
        HttpUrl.Builder urlBuilder = request.url().newBuilder();

        if (body instanceof MultipartBody) {
            MultipartBody multipartBody = (MultipartBody) body;
            List<MultipartBody.Part> parts = multipartBody.parts();
            StringBuilder fileBuilder = new StringBuilder();
            for (int i = 0, size = parts.size(); i < size; i++) {
                MultipartBody.Part part = parts.get(i);
                RequestBody requestBody = part.body();
                Headers headers = part.headers();
                if (headers == null || headers.size() == 0) {
                    continue;
                }
                String[] split = headers.value(0).split(";");
                String name = null, fileName = null;
                for (String s : split) {
                    if (s.equals("form-data")) {
                        continue;
                    }
                    String[] keyValue = s.split("=");
                    if (keyValue.length < 2) {
                        continue;
                    }
                    String value = keyValue[1].substring(1, keyValue[1].length() - 1);
                    if (name == null) {
                        name = value;
                    } else {
                        fileName = value;
                        break;
                    }
                }
                if (name == null) {
                    continue;
                }
                if (requestBody.contentLength() < 1024) {
                    Buffer buffer = new Buffer();
                    requestBody.writeTo(buffer);
                    String value = buffer.readUtf8();
                    urlBuilder.addQueryParameter(name, value);
                } else {
                    if (fileBuilder.length() > 0) {
                        fileBuilder.append("&");
                    }
                    fileBuilder.append(name).append("=").append(fileName);
                }
            }
            return urlBuilder.toString() + "\n\nfiles = " + fileBuilder.toString();
        }

        if (body != null) {
            Buffer buffer = new Buffer();
            body.writeTo(buffer);
            if (!isPlaintext(buffer)) {
                return urlBuilder.toString() + "\n\n(binary "
                        + body.contentLength() + "-byte body omitted)";
            } else {
                return urlBuilder.toString() + "\n\n" + buffer.readUtf8();
            }
        }
        return urlBuilder.toString();
    }

    @SuppressWarnings("deprecation")
    private static String getResult(ResponseBody body) throws IOException {
        BufferedSource source = body.source();
        source.request(Long.MAX_VALUE); // Buffer the entire body.
        Buffer buffer = source.buffer();
        String result;
        if (isPlaintext(buffer)) {
            Charset UTF_8 = Charset.forName("UTF-8");
            MediaType contentType = body.contentType();
            if (contentType != null) {
                UTF_8 = contentType.charset(UTF_8);
            }
            //加解密
            result = HttpManage.getResult(buffer.clone().readString(UTF_8));
        } else {
            result = "(binary " + buffer.size() + "-byte body omitted)";
        }
        return result;
    }


    private static boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64 ? buffer.size() : 64;
            buffer.copyTo(prefix, 0, byteCount);
            for (int i = 0; i < 16; i++) {
                if (prefix.exhausted()) {
                    break;
                }
                int codePoint = prefix.readUtf8CodePoint();
                if (Character.isISOControl(codePoint) && !Character.isWhitespace(codePoint)) {
                    return false;
                }
            }
            return true;
        } catch (EOFException e) {
            // Truncated UTF-8 sequence.
            return false;
        }
    }

    class LogTime {

        private long startNs;

        public LogTime() {
            this.startNs = System.nanoTime();
        }

        public long tookMs() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs);
        }
    }

    public static void logi(String tag, String message) {
        System.out.println(tag + ": " + message);
    }

    public static void logd(String tag, String message) {
        System.out.println(tag + ": " + message);
    }

    public static void loge(String tag, String message) {
        System.out.println(tag + ": " + message);
    }

    public static void logd(String tag, String message, Throwable e) {
        System.out.println(tag + ": " + message);
    }
}
