package cn.lsmya.http.builder;

import cn.lsmya.http.GsonUtil;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * postJson请求构造器
 */
public class PostJsonBuilder extends HttpBuilder<PostJsonBuilder> {

    private String jsonParam;

    public PostJsonBuilder(String url) {
        super(url);
    }

    public PostJsonBuilder add(String param) {
        this.jsonParam = param;
        return this;
    }

    public RequestBody getRequestBody() {
        if (jsonParam == null) {
            if (getParams().isEmpty()) {
                return RequestBody.create(null, new byte[0]);
            } else {
                MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
                return RequestBody.create(mediaType, GsonUtil.toJson(getParams()));
            }
        } else {
            MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
            return RequestBody.create(mediaType, jsonParam);
        }
    }

    public static PostJsonBuilder with(String url) {
        return new PostJsonBuilder(url);
    }
}
