package cn.lsmya.http.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import cn.lsmya.http.entity.UpFile;
import cn.lsmya.http.listener.OnProgressListener;
import cn.lsmya.http.listener.ProgressRequestBody;
import cn.lsmya.http.other.BuildBodyUtil;
import cn.lsmya.http.param.IFile;
import io.reactivex.annotations.NonNull;
import okhttp3.RequestBody;

/**
 * postForm请求构造器
 */
public class PostFormBuilder extends HttpBuilder<PostFormBuilder> implements IFile<PostFormBuilder> {

    private List<UpFile> list;
    private OnProgressListener mOnProgressListener;

    public PostFormBuilder(String url) {
        super(url);
    }

    public RequestBody getRequestBody() {
        RequestBody requestBody;
        if (list == null || list.isEmpty()) {
            requestBody = BuildBodyUtil.buildFormRequestBody(getParams());
        } else {
            requestBody = BuildBodyUtil.buildFormRequestBody(getParams(), list);
        }
        if (mOnProgressListener != null) {
            //如果设置了进度回调，则对RequestBody进行装饰
            requestBody = new ProgressRequestBody(requestBody, mOnProgressListener);
        }
        return requestBody;
    }

    public static PostFormBuilder with(String url) {
        return new PostFormBuilder(url);
    }

    @Override
    public PostFormBuilder add(String key, File file) {
        return addFile(key, file.getAbsolutePath());
    }

    @Override
    public PostFormBuilder addFile(String key, File file) {
        return addFile(key, file.getAbsolutePath());
    }

    @Override
    public PostFormBuilder addFile(String key, String filePath) {
        return addFile(new UpFile(key, filePath));
    }

    @Override
    public PostFormBuilder addFile(String key, String value, String filePath) {
        UpFile upFile = new UpFile(key, filePath);
        upFile.setValue(value);
        return addFile(upFile);
    }

    @Override
    public PostFormBuilder addFile(String key, String value, File file) {
        return addFile(key, value, file.getAbsolutePath());
    }

    @Override
    public PostFormBuilder addFile(String key, List<File> fileList) {
        for (File file : fileList) {
            addFile(new UpFile(key, file.getAbsolutePath()));
        }
        return this;
    }

    @Override
    public PostFormBuilder addFile(List<UpFile> upFileList) {
        for (UpFile upFile : upFileList) {
            addFile(upFile);
        }
        return this;
    }

    @Override
    public PostFormBuilder removeFile(String key) {
        final List<UpFile> fileList = list;
        if (fileList == null || key == null) {
            return this;
        }
        Iterator<UpFile> it = fileList.iterator();
        while (it.hasNext()) {
            UpFile upFile = it.next();
            if (key.equals(upFile.getKey())) {
                it.remove();
            }
        }
        return this;
    }

    @Override
    public PostFormBuilder setProgressCallback(OnProgressListener callback) {
        this.mOnProgressListener = callback;
        return this;
    }


    private PostFormBuilder addFile(@NonNull UpFile upFile) {
        if (list == null) {
            list = new ArrayList<>();
        }
        list.add(upFile);
        return this;
    }
}
