package cn.lsmya.http.builder;

import cn.lsmya.http.GsonUtil;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * patchJson请求构造器
 */
public class PatchJsonBuilder extends HttpBuilder<PatchJsonBuilder> {

    private String jsonParam;

    public PatchJsonBuilder(String url) {
        super(url);
    }

    public PatchJsonBuilder add(String param) {
        this.jsonParam = param;
        return this;
    }

    public RequestBody getRequestBody() {
        if (jsonParam == null) {
            if (getParams().isEmpty()) {
                return RequestBody.create(null, new byte[0]);
            } else {
                MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
                return RequestBody.create(mediaType, GsonUtil.toJson(getParams()));
            }
        } else {
            MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
            return RequestBody.create(mediaType, jsonParam);
        }
    }

    public static PatchJsonBuilder with(String url) {
        return new PatchJsonBuilder(url);
    }
}
