package cn.lsmya.http;

import java.io.IOException;

import cn.lsmya.http.listener.OnProgressListener;
import okhttp3.Interceptor;
import okhttp3.Response;

/**
 * 下载进度拦截器
 */
public class ProgressInterceptor implements Interceptor {

    private OnProgressListener progressCallback;

    public ProgressInterceptor(OnProgressListener progressCallback) {
        this.progressCallback = progressCallback;
    }

    @Override
    public Response intercept(Chain chain) throws IOException {
        //拦截
        Response originalResponse = chain.proceed(chain.request());
        //包装响应体并返回
        return originalResponse.newBuilder()
                .body(new ProgressResponseBody(originalResponse, progressCallback))
                .build();
    }
}
