package cn.lsmya.http.param;

import java.util.Map;

import okhttp3.Headers;

/**
 * 请求头操作处理
 *
 * @param <T>
 */
public interface IHeaders<T> {

    T addHeader(String line);

    T addHeader(String line, boolean isAdd);

    T addHeader(String key, String value);

    T addHeader(String key, String value, boolean isAdd);

    T addHeader(Map<String, String> headerMap);

    T addHeader(Map<String, String> headerMap, boolean isAdd);

    T setHeader(String key, String value);

    T setHeader(String key, String value, boolean isAdd);

    String getHeader(String key);

    Headers getHeaders();

    Headers.Builder getHeadersBuilder();

    T setHeadersBuilder(Headers.Builder builder);

    T removeAllHeader(String key);

}
