package cn.lsmya.http.param;

import java.io.File;
import java.util.List;

import cn.lsmya.http.entity.UpFile;
import cn.lsmya.http.listener.OnProgressListener;

/**
 * User: ljx
 * Date: 2019-05-19
 * Time: 18:18
 */
@SuppressWarnings("unchecked")
public interface IFile<P> {

    P add(String key, File file);

    P addFile(String key, File file);

    P addFile(String key, String filePath);

    P addFile(String key, String value, String filePath);

    P addFile(String key, String value, File file);

    P addFile(String key, List<File> fileList);

    P addFile(List<UpFile> upFileList);

    /**
     * 根据key 移除已添加的文件
     *
     * @param key String
     * @return Param
     */
    P removeFile(String key);

    /**
     * <p>设置上传进度监听器
     *
     * @param callback 进度回调对象
     * @return Param
     */
    P setProgressCallback(OnProgressListener callback);
}
