package cn.lsmya.http.other;

import java.net.URLConnection;
import java.util.List;

import cn.lsmya.http.entity.KeyValuePair;
import cn.lsmya.http.entity.UpFile;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class BuildBodyUtil {
    /**
     * 构建一个表单 (不带文件)
     *
     * @param map map参数集合
     * @return RequestBody
     */
    public static RequestBody buildFormRequestBody(List<KeyValuePair> map) {
        FormBody.Builder builder = new FormBody.Builder();
        if (map != null) {
            for (KeyValuePair entry : map) {
                if (entry.isEncoded()) {
                    builder.addEncoded(entry.getKey(), entry.getValue().toString());
                } else {
                    builder.add(entry.getKey(), entry.getValue().toString());
                }

            }
        }
        return builder.build();
    }

    /**
     * 构建一个表单(带文件)
     *
     * @param map      map参数集合
     * @param fileList 文件列表
     * @return RequestBody
     */
    public static RequestBody buildFormRequestBody(List<KeyValuePair> map,
                                                   List<UpFile> fileList) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MultipartBody.FORM);
        if (map != null) {
            //遍历参数
            for (KeyValuePair entry : map) {
                builder.addFormDataPart(entry.getKey(), entry.getValue().toString());
            }
        }
        if (fileList != null) {
            //遍历文件
            for (UpFile file : fileList) {
                if (!file.exists() || !file.isFile()) {
                    continue;
                }
                RequestBody requestBody = RequestBody.create(getMediaType(file.getName()), file);
                builder.addFormDataPart(file.getKey(), file.getValue(), requestBody);
            }
        }
        return builder.build();
    }

    private static MediaType getMediaType(String fName) {
        String contentType = URLConnection.guessContentTypeFromName(fName);
        if (contentType == null || contentType.isEmpty()) {
            contentType = "application/octet-stream";
        }
        return MediaType.parse(contentType);
    }
}
