package cn.lsmya.http.builder;

import cn.lsmya.http.GsonUtil;
import okhttp3.MediaType;
import okhttp3.RequestBody;

/**
 * putJson请求构造器
 */
public class PutJsonBuilder extends HttpBuilder<PutJsonBuilder> {

    private String jsonParam;

    public PutJsonBuilder(String url) {
        super(url);
    }

    public PutJsonBuilder add(String param) {
        this.jsonParam = param;
        return this;
    }

    public RequestBody getRequestBody() {
        if (jsonParam == null) {
            if (getParams().isEmpty()) {
                return RequestBody.create(null, new byte[0]);
            } else {
                MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
                return RequestBody.create(mediaType, GsonUtil.toJson(getParams()));
            }
        } else {
            MediaType mediaType = MediaType.parse("application/json; charset=utf-8");
            return RequestBody.create(mediaType, jsonParam);
        }
    }

    public static PutJsonBuilder with(String url) {
        return new PutJsonBuilder(url);
    }
}
