package cn.lsmya.http;

import android.text.TextUtils;

import cn.lsmya.http.listener.OnRequestListener;
import cn.lsmya.http.listener.OnResultListener;
import cn.lsmya.http.other.HttpSender;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class HttpManage {
    private static boolean mDebug = false;

    private static OkHttpClient mOkHttpClient;

    private static String mBaseUrl;
    private static OnRequestListener mOnRequestListener;
    private static OnResultListener mOnResultListener;

    public static void setDebug(boolean debug) {
        mDebug = debug;
    }

    public static boolean getDebug() {
        return mDebug;
    }

    public static void setOkHttpClient(OkHttpClient okHttpClient) {
        if (mOkHttpClient != null) {
            throw new IllegalArgumentException("OkHttpClient can only be initialized once");
        }
        mOkHttpClient = okHttpClient;
    }

    public static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = HttpSender.getDefaultOkHttpClient();
        }
        return mOkHttpClient;
    }

    public static String getBaseUrl() {
        return TextUtils.isEmpty(mBaseUrl) ? "" : mBaseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        if (mBaseUrl != null) {
            throw new IllegalArgumentException("baseUrl can only be initialized once");
        }
        mBaseUrl = baseUrl;
    }

    public static void setRequestCallback(OnRequestListener listener) {
        if (mOnRequestListener != null) {
            throw new IllegalArgumentException("OnRequestListener can only be initialized once");
        }
        mOnRequestListener = listener;
    }

    public static void setResultCallback(OnResultListener listener) {
        if (mOnResultListener != null) {
            throw new IllegalArgumentException("OnResultListener can only be initialized once");
        }
        mOnResultListener = listener;
    }

    public static Request getRequest(Request request) {
        if (mOnRequestListener != null) {
            return mOnRequestListener.onIntercept(request);
        } else {
            return request;
        }
    }

    public static String getResult(String s) {
        if (mOnResultListener != null) {
            return mOnResultListener.onIntercept(s);
        } else {
            return s;
        }
    }

}
