package cn.lsmya.http;

import cn.lsmya.http.builder.DeleteFormBuilder;
import cn.lsmya.http.builder.DeleteJsonBuilder;
import cn.lsmya.http.builder.GetBuilder;
import cn.lsmya.http.builder.PatchFormBuilder;
import cn.lsmya.http.builder.PatchJsonBuilder;
import cn.lsmya.http.builder.PostFormBuilder;
import cn.lsmya.http.builder.PostJsonBuilder;
import cn.lsmya.http.builder.PutFormBuilder;
import cn.lsmya.http.builder.PutJsonBuilder;
import cn.lsmya.http.listener.OnRequestListener;
import cn.lsmya.http.listener.OnResultListener;
import okhttp3.OkHttpClient;

public class Http {

    public static void setDebug(boolean debug) {
        HttpManage.setDebug(debug);
    }

    public static void setOkHttpClient(OkHttpClient okHttpClient) {
        HttpManage.setOkHttpClient(okHttpClient);
    }

    public static void setBaseUrl(String baseUrl) {
        HttpManage.setBaseUrl(baseUrl);
    }

    public static void setRequestCallback(OnRequestListener listener) {
        HttpManage.setRequestCallback(listener);
    }

    public static void setResultCallback(OnResultListener listener) {
        HttpManage.setResultCallback(listener);
    }

    /**
     * Get 请求
     */
    public static GetBuilder get(String url) {
        return GetBuilder.with(url);
    }

    /**
     * Post Form请求
     */
    public static PostFormBuilder postForm(String url) {
        return PostFormBuilder.with(url);
    }

    /**
     * Post JSON请求
     */

    public static PostJsonBuilder postJSON(String url) {
        return PostJsonBuilder.with(url);
    }

    /**
     * Delete Form请求
     */
    public static DeleteFormBuilder deleteForm(String url) {
        return DeleteFormBuilder.with(url);
    }

    /**
     * Delete JSON请求
     */
    public static DeleteJsonBuilder deleteJSON(String url) {
        return DeleteJsonBuilder.with(url);
    }

    /**
     * Put Form请求
     */
    public static PutFormBuilder putForm(String url) {
        return PutFormBuilder.with(url);
    }

    /**
     * Put JSON请求
     */
    public static PutJsonBuilder putJSON(String url) {
        return PutJsonBuilder.with(url);
    }

    /**
     * Put Form请求
     */
    public static PatchFormBuilder patchForm(String url) {
        return PatchFormBuilder.with(url);
    }

    /**
     * Put JSON请求
     */
    public static PatchJsonBuilder patchJSON(String url) {
        return PatchJsonBuilder.with(url);
    }
}
