package rx.library.http;

import android.text.TextUtils;

import okhttp3.OkHttpClient;
import okhttp3.Request;
import rx.library.http.other.QXHttpLogUtil;
import rx.library.http.other.QXHttpSender;

public class ApiInitialize {

    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int ERROR = 3;

    public static String mBaseUrl;
    /**
     * 只能初始化一次,第二次将抛出异常
     */
    private static OkHttpClient mOkHttpClient;
    private static OkHttpClient mDownloadOkHttpClient;

    private static ApiInitListener mApiInitListener;

    public static void init(OkHttpClient okHttpClient) {
        if (mOkHttpClient != null) {
            throw new IllegalArgumentException("OkHttpClient can only be initialized once");
        }
        mOkHttpClient = okHttpClient;
    }

    public static OkHttpClient getOkHttpClient() {
        if (mOkHttpClient == null) {
            mOkHttpClient = QXHttpSender.getDefaultOkHttpClient();
        }
        return mOkHttpClient;
    }

    public static OkHttpClient getDownloadOkHttpClient() {
        return mDownloadOkHttpClient;
    }

    public static void setDownloadOkHttpClient(OkHttpClient mDownloadOkHttpClient) {
        ApiInitialize.mDownloadOkHttpClient = mDownloadOkHttpClient;
    }

    public static void setDebug(boolean debug) {
        setDebug(debug, DEBUG);
    }

    public static void setDebug(boolean debug, int level) {
        QXHttpLogUtil.setDebug(debug, level);
    }

    public static String getBaseUrl() {
        return TextUtils.isEmpty(mBaseUrl) ? "" : mBaseUrl;
    }

    public static void setBaseUrl(String baseUrl) {
        if (mBaseUrl != null) {
            throw new IllegalArgumentException("baseUrl can only be initialized once");
        }
        mBaseUrl = baseUrl;
    }

    public static Request getRequest(Request request) {
        if (mApiInitListener != null) {
            return mApiInitListener.initHttp(request);
        } else {
            return request;
        }
    }

    public static void setApiInitListener(ApiInitListener apiInitListener) {
        if (mApiInitListener != null) {
            throw new IllegalArgumentException("ApiInitListener can only be initialized once");
        }
        mApiInitListener = apiInitListener;
    }

}
