package rx.library.http;

import okhttp3.Call;
import okhttp3.OkHttpClient;
import rx.library.http.builder.*;

public class Api {

    /**
     * Get 请求
     */
    public static GetBuilderHttp get() {
        return get(null);
    }

    public static GetBuilderHttp get(String url) {
        return GetBuilderHttp.with(url);
    }

    /**
     * Post Form请求
     */
    public static PostFormBuilderHttp postForm() {
        return postForm(null);
    }

    public static PostFormBuilderHttp postForm(String url) {
        return PostFormBuilderHttp.with(url);
    }

    /**
     * Post JSON请求
     */
    public static PostJSONBuilderHttp postJSON() {
        return postJSON(null);
    }

    public static PostJSONBuilderHttp postJSON(String url) {
        return PostJSONBuilderHttp.with(url);
    }

    /**
     * Delete Form请求
     */
    public static DeleteFormBuilderHttp deleteForm() {
        return deleteForm(null);
    }

    public static DeleteFormBuilderHttp deleteForm(String url) {
        return DeleteFormBuilderHttp.with(url);
    }

    /**
     * Delete JSON请求
     */
    public static DeleteJSONBuilderHttp deleteJSON() {
        return deleteJSON(null);
    }

    public static DeleteJSONBuilderHttp deleteJSON(String url) {
        return DeleteJSONBuilderHttp.with(url);
    }

    /**
     * Put Form请求
     */
    public static PutFormBuilderHttp putForm() {
        return putForm(null);
    }

    public static PutFormBuilderHttp putForm(String url) {
        return PutFormBuilderHttp.with(url);
    }

    /**
     * Put JSON请求
     */
    public static PutJSONBuilderHttp putJSON() {
        return putJSON(null);
    }

    public static PutJSONBuilderHttp putJSON(String url) {
        return PutJSONBuilderHttp.with(url);
    }

    /**
     * GET 下载文件
     */
    public static DownloadBuilderHttp download() {
        return download(null);
    }

    public static DownloadBuilderHttp download(String url) {
        return DownloadBuilderHttp.with(url);
    }

    /**
     * 根据tag取消请求
     */
    public static void cancel(final Object tag) {
        OkHttpClient mOkHttpClient = ApiInitialize.getOkHttpClient();
        try {
            for (Call call : mOkHttpClient.dispatcher().queuedCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
            for (Call call : mOkHttpClient.dispatcher().runningCalls()) {
                if (call.request().tag().toString().contains(tag.toString())) {
                    call.cancel();
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void cancelDownload(final Object tag) {
        OkHttpClient mOkHttpClient = ApiInitialize.getDownloadOkHttpClient();
        if (mOkHttpClient != null) {
            try {
                for (Call call : mOkHttpClient.dispatcher().queuedCalls()) {
                    if (call.request().tag().toString().contains(tag.toString())) {
                        call.cancel();
                    }
                }
                for (Call call : mOkHttpClient.dispatcher().runningCalls()) {
                    if (call.request().tag().toString().contains(tag.toString())) {
                        call.cancel();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

}
