package rx.library.http.other;

import android.text.TextUtils;
import android.util.Log;

import java.io.File;
import java.util.Map;
import java.util.Set;

import okhttp3.Headers;
import rx.library.http.ApiInitialize;

public class QXHttpLogUtil {
    private static boolean mDebug;
    private static int mLogLevel;

    public static boolean isDebug() {
        return mDebug;
    }

    public static void setDebug(boolean debug, int logLevel) {
        mDebug = debug;
        mLogLevel = logLevel;
    }

    public static void log(String tag, String url, String logStr) {
        if (isDebug()) {
            switch (mLogLevel) {
                case ApiInitialize.DEBUG:
                    Log.d("「 " + url + " 」" + tag, logStr);
                    break;
                case ApiInitialize.INFO:
                    Log.i("「 " + url + " 」" + tag, logStr);
                    break;
                default:
                    Log.e("「 " + url + " 」" + tag, logStr);
                    break;
            }
        }

    }

    public static void logHeader(String url, Headers headers) {
        String header = getHeader(headers);
        log("头部", url, header);
    }

    public static void logParams(String url, Map<String, Object> map, Map<String, File> fileMap) {
        String params = getParams(map);
        log("参数", url, params);
        if (fileMap.size() != 0) {
            String fileNames = getFileNames(fileMap);
            log("文件", url, fileNames);
        }
    }

    private static String getHeader(Headers headers) {
        if (headers != null && headers.size() != 0) {
            String returnStr = "";
            Set<String> names = headers.names();
            for (String name : names) {
                String value = headers.get(name);
                String str = "\"" + name + "\":\"" + value + "\"";
                if (TextUtils.isEmpty(returnStr)) {
                    returnStr = str;
                } else {
                    returnStr = returnStr.concat(",".concat(str));
                }
            }
            return returnStr;
        } else {
            return "未设置请求头";
        }
    }


    private static String getParams(Map<String, Object> map) {
        if (map == null || map.size() == 0) {
            return "未上传参数";
        } else {
            String returnStr = "";
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().toString();
                String str = "\"" + key + "\":\"" + value + "\"";
                if (TextUtils.isEmpty(returnStr)) {
                    returnStr = str;
                } else {
                    returnStr = returnStr.concat(",".concat(str));
                }
            }
            return "{" + returnStr + "}";
        }

    }

    private static String getFileNames(Map<String, File> map) {
        if (map == null || map.size() == 0) {
            return "未上传参数";
        } else {
            String returnStr = "";
            for (Map.Entry<String, File> entry : map.entrySet()) {
                String key = entry.getKey();
                File value = entry.getValue();
                String str = "\"" + key + "\":\"" + value.getName() + "\"";
                if (TextUtils.isEmpty(returnStr)) {
                    returnStr = str;
                } else {
                    returnStr = returnStr.concat(",".concat(str));
                }
            }
            return "{" + returnStr + "}";
        }

    }
}
