package rx.library.http.builder;

import rx.library.http.ApiDownloadCallBack;
import rx.library.http.other.QXHttpBuildUtil;

public class DownloadBuilderHttp extends DownloadHttpBuilder {

    public DownloadBuilderHttp(String url) {
        super(url);
    }

    public static DownloadBuilderHttp with(String url) {
        return new DownloadBuilderHttp(url);
    }

    @Override
    public void builder(String path, ApiDownloadCallBack apiDownloadCallBack) {
        super.downloading(path, QXHttpBuildUtil.createDownloadRequest(DownloadBuilderHttp.this), apiDownloadCallBack);
    }
}
