package cn.lsmya.fileprovider;

import android.content.Context;
import android.net.Uri;
import android.os.Build;

import java.io.File;

/**
 * Android7.0以上用于在不同应用间共享文件
 */
public class FileProviderHelper {

    public static Uri getUriForFile(Context context, File file) {
        Uri fileUri = null;
        if (Build.VERSION.SDK_INT >= 24) {
            fileUri = getUriForFile24(context, file);
        } else {
            fileUri = Uri.fromFile(file);
        }
        return fileUri;
    }

    private static Uri getUriForFile24(Context context, File file) {
        Uri fileUri = androidx.core.content.FileProvider.getUriForFile(context,
                context.getPackageName() + ".android7.fileprovider", file);
        return fileUri;
    }

}
