package cn.lsmya.file;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import com.gyf.immersionbar.ImmersionBar;
import com.tencent.smtt.sdk.TbsReaderView;

import java.io.File;

public class OpenFileHelper extends AppCompatActivity {
    private TbsReaderView mTbsReaderView;
    private RelativeLayout layout;
    private Toolbar toolbar;
    private String filePath;

    public static void open(Activity activity, String filePath) {
        open(activity, "查看文件", filePath);
    }

    public static void open(Activity activity, String title, String filePath) {
        Intent intent = new Intent(activity, OpenFileHelper.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        activity.startActivity(intent);
    }

    public static void open(Activity activity, String filePath, int requestCode) {
        open(activity, "查看文件", filePath, requestCode);
    }

    public static void open(Activity activity, String title, String filePath, int requestCode) {
        Intent intent = new Intent(activity, OpenFileHelper.class);
        intent.putExtra("filePath", filePath);
        intent.putExtra("title", title);
        activity.startActivityForResult(intent, requestCode);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.helper_activity_open_file);
        boolean nightMode = (getResources().getConfiguration().uiMode & Configuration.UI_MODE_NIGHT_MASK) == Configuration.UI_MODE_NIGHT_YES;
        ImmersionBar.with(this)
                .statusBarDarkFont(!nightMode)
                .fitsSystemWindows(true)
                .statusBarColor(R.color.titleBackground)
                .init();
        filePath = getIntent().getStringExtra("filePath");
        layout = findViewById(R.id.helperOpenFile_layout);
        toolbar = findViewById(R.id.helperOpenFile_toolbar);
        toolbar.setNavigationIcon(R.drawable.hepler_office_open_back);
        mTbsReaderView = new TbsReaderView(this, null);
        layout.addView(mTbsReaderView, new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        toolbar.setTitle(getIntent().getStringExtra("title"));
        toolbar.setNavigationOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        Bundle bundle = new Bundle();
        bundle.putString("filePath", filePath);
        bundle.putString("tempPath", new File(filePath).getParent());
        boolean result = mTbsReaderView.preOpen(parseFormat(new File(filePath).getName()), false);
        if (result) {
            mTbsReaderView.openFile(bundle);
        }
    }

    private String parseFormat(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        try {
            mTbsReaderView.onStop();
        } catch (Exception e) {
        }
    }
}
