package cn.lsmya.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import cn.lsmya.view.R;

/**
 * 可直接设置圆角、边框的RelativeLayout
 *
 * @author lsm
 */
public class UISuperRelativeLayout extends RelativeLayout {
    private static final int WIDTH = 0x0;
    private static final int HEIGHT = 0x1;
    private int maxSize = 0x2;
    private Paint paint;
    private Paint paintBorder;
    private int startColor = -1;
    private int stopColor = -1;
    private GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;
    /**
     * 圆角大小
     */
    private float radius = -1;
    private float tlRadius = 0;
    private float blRadius = 0;
    private float trRadius = 0;
    private float brRadius = 0;
    private int borderColor = Color.TRANSPARENT;
    private int borderWidth = 0;
    private Paint paint2;

    public UISuperRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context, attrs);
    }

    public UISuperRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public UISuperRelativeLayout(Context context) {
        super(context);
        init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UISuperRelativeLayout);
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.UISuperRelativeLayout_ui_radius) {
                radius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_borderColor) {
                borderColor = typedArray.getColor(attr, Color.TRANSPARENT);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_borderWidth) {
                borderWidth = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_tlRadius) {
                tlRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_blRadius) {
                blRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_trRadius) {
                trRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_brRadius) {
                brRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_maxSize) {
                maxSize = typedArray.getInt(attr, 0);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_startColor) {
                startColor = typedArray.getColor(attr, -1);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_stopColor) {
                stopColor = typedArray.getColor(attr, -1);
            } else if (attr == R.styleable.UISuperRelativeLayout_ui_orientation) {
                orientation = getOrientation(typedArray.getInt(attr,-1));
            }
        }
        typedArray.recycle();

        paint = new Paint();
        paint.setColor(Color.WHITE);
        paint.setAntiAlias(true);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        paintBorder = new Paint();
        paintBorder.setColor(borderColor);
        paintBorder.setStrokeWidth(borderWidth);
        paintBorder.setStyle(Paint.Style.STROKE);
        paintBorder.setAntiAlias(true);

        paint2 = new Paint();
        paint2.setAntiAlias(true);
        paint2.setXfermode(null);
        if (startColor != -1 && stopColor != -1) {
            int[] colors = {startColor, stopColor};
            GradientDrawable mGradientDrawable = new GradientDrawable();
            mGradientDrawable.setOrientation(orientation);
            mGradientDrawable.setColors(colors);
            setBackground(mGradientDrawable);
        }
    }

    private GradientDrawable.Orientation getOrientation(int orientation) {
        switch (orientation) {
            case 0:
                return GradientDrawable.Orientation.TOP_BOTTOM;
            case 1:
                return GradientDrawable.Orientation.TR_BL;
            case 2:
                return GradientDrawable.Orientation.RIGHT_LEFT;
            case 3:
                return GradientDrawable.Orientation.BR_TL;
            case 4:
                return GradientDrawable.Orientation.BOTTOM_TOP;
            case 5:
                return GradientDrawable.Orientation.BL_TR;
            case 6:
                return GradientDrawable.Orientation.LEFT_RIGHT;
            case 7:
                return GradientDrawable.Orientation.TL_BR;
            default:
                return GradientDrawable.Orientation.LEFT_RIGHT;
        }

    }

    @Override
    protected void onDraw(Canvas canvas) {
        drawLiftUp(canvas, paintBorder);
        drawLiftDown(canvas, paintBorder);
        drawRightUp(canvas, paintBorder);
        drawRightDown(canvas, paintBorder);
        canvas.drawLine(0, 0, getWidth(), 0, paintBorder);
        canvas.drawLine(0, getHeight(), getWidth(), getHeight(), paintBorder);
        canvas.drawLine(0, 0, 0, getHeight(), paintBorder);
        canvas.drawLine(getWidth(), 0, getWidth(), getHeight(), paintBorder);
        super.onDraw(canvas);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (maxSize == WIDTH) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childWidthSize = getMeasuredWidth();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        } else if (maxSize == HEIGHT) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childHeightSize = getMeasuredHeight();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childHeightSize, MeasureSpec.EXACTLY);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);

    }

    @Override
    public void draw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap(getWidth(), getHeight(), Bitmap.Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        super.draw(canvas2);
        drawLiftUp(canvas2, paint);
        drawLiftDown(canvas2, paint);
        drawRightUp(canvas2, paint);
        drawRightDown(canvas2, paint);
        canvas.drawBitmap(bitmap, 0, 0, paint2);
        bitmap.recycle();
    }

    private void drawLiftUp(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(tlRadius);
        Path path = new Path();
        path.moveTo(0, useRadius);
        path.lineTo(0, 0);
        path.lineTo(useRadius, 0);
        path.arcTo(new RectF(0, 0, useRadius * 2, useRadius * 2), -90, -90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawLiftDown(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(blRadius);
        Path path = new Path();
        path.moveTo(0, getHeight() - useRadius);
        path.lineTo(0, getHeight());
        path.lineTo(useRadius, getHeight());
        path.arcTo(new RectF(0, getHeight() - useRadius * 2, useRadius * 2, getHeight()), 90, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawRightDown(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(brRadius);
        Path path = new Path();
        path.moveTo(getWidth() - useRadius, getHeight());
        path.lineTo(getWidth(), getHeight());
        path.lineTo(getWidth(), getHeight() - useRadius);
        path.arcTo(new RectF(getWidth() - useRadius * 2, getHeight() - useRadius * 2, getWidth(), getHeight()), -0, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawRightUp(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(trRadius);
        Path path = new Path();
        path.moveTo(getWidth(), useRadius);
        path.lineTo(getWidth(), 0);
        path.lineTo(getWidth() - useRadius, 0);
        path.arcTo(new RectF(getWidth() - useRadius * 2, 0, getWidth(), 0 + useRadius * 2), -90, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private float getRadius(float mRadius) {
        float r = radius == -1 ? mRadius : radius;
        int mHeight = getHeight() / 2;
        return r > mHeight ? mHeight : r;
    }
}