package cn.lsmya.view.textview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Bitmap.Config;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.util.AttributeSet;

import androidx.appcompat.widget.AppCompatTextView;

import cn.lsmya.view.R;

/**
 * 实现圆角、边框的TextView
 *
 * @author lsm
 */
public class SuperTextView extends AppCompatTextView {
    private static final int WIDTH = 0x0;
    private static final int HEIGHT = 0x1;
    private int maxSize = 0x2;
    private Paint paint;
    private Paint paintBorder;
    private Paint paint2;

    /**
     * 圆角大小
     */
    private float radius = -1;
    private float tlRadius = 0;
    private float blRadius = 0;
    private float trRadius = 0;
    private float brRadius = 0;
    private int borderColor = Color.TRANSPARENT;
    private int borderWidth = 0;

    public SuperTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context, attrs);
    }

    public SuperTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public SuperTextView(Context context) {
        super(context);
        init(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        @SuppressLint("CustomViewStyleable") TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SuperView);
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.SuperView_radius) {
                radius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_borderColor) {
                borderColor = typedArray.getColor(attr, Color.TRANSPARENT);
            } else if (attr == R.styleable.SuperView_borderWidth) {
                borderWidth = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_tlRadius) {
                tlRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_blRadius) {
                blRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_trRadius) {
                trRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_brRadius) {
                brRadius = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.SuperView_maxSize) {
                maxSize = typedArray.getInt(attr, 0);
            }
        }
        typedArray.recycle();

        paint = new Paint();
        paint.setColor(Color.WHITE);
        paint.setAntiAlias(true);
        paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));

        paintBorder = new Paint();
        paintBorder.setColor(borderColor);
        paintBorder.setStrokeWidth(borderWidth);
        paintBorder.setStyle(Paint.Style.STROKE);
        paintBorder.setAntiAlias(true);

        paint2 = new Paint();
        paint2.setAntiAlias(true);
        paint2.setXfermode(null);

    }

    @Override
    protected void onDraw(Canvas canvas) {
        drawLiftUp(canvas, paintBorder);
        drawLiftDown(canvas, paintBorder);
        drawRightUp(canvas, paintBorder);
        drawRightDown(canvas, paintBorder);
        canvas.drawLine(0, 0, getWidth(), 0, paintBorder);
        canvas.drawLine(0, getHeight(), getWidth(), getHeight(), paintBorder);
        canvas.drawLine(0, 0, 0, getHeight(), paintBorder);
        canvas.drawLine(getWidth(), 0, getWidth(), getHeight(), paintBorder);
        super.onDraw(canvas);
    }


    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (maxSize == WIDTH) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childWidthSize = getMeasuredWidth();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        } else if (maxSize == HEIGHT) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childHeightSize = getMeasuredHeight();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childHeightSize, MeasureSpec.EXACTLY);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);

    }

    @Override
    public void draw(Canvas canvas) {
        Bitmap bitmap = Bitmap.createBitmap(getWidth(), getHeight(), Config.ARGB_8888);
        Canvas canvas2 = new Canvas(bitmap);
        super.draw(canvas2);
        drawLiftUp(canvas2, paint);
        drawLiftDown(canvas2, paint);
        drawRightUp(canvas2, paint);
        drawRightDown(canvas2, paint);
        canvas.drawBitmap(bitmap, 0, 0, paint2);
        bitmap.recycle();
    }

    private void drawLiftUp(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(tlRadius);
        Path path = new Path();
        path.moveTo(0, useRadius);
        path.lineTo(0, 0);
        path.lineTo(useRadius, 0);
        path.arcTo(new RectF(0, 0, useRadius * 2, useRadius * 2), -90, -90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawLiftDown(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(blRadius);
        Path path = new Path();
        path.moveTo(0, getHeight() - useRadius);
        path.lineTo(0, getHeight());
        path.lineTo(useRadius, getHeight());
        path.arcTo(new RectF(0, getHeight() - useRadius * 2, useRadius * 2, getHeight()), 90, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawRightDown(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(brRadius);
        Path path = new Path();
        path.moveTo(getWidth() - useRadius, getHeight());
        path.lineTo(getWidth(), getHeight());
        path.lineTo(getWidth(), getHeight() - useRadius);
        path.arcTo(new RectF(getWidth() - useRadius * 2, getHeight() - useRadius * 2, getWidth(), getHeight()), -0, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private void drawRightUp(Canvas canvas, Paint mPaint) {
        float useRadius = getRadius(trRadius);
        Path path = new Path();
        path.moveTo(getWidth(), useRadius);
        path.lineTo(getWidth(), 0);
        path.lineTo(getWidth() - useRadius, 0);
        path.arcTo(new RectF(getWidth() - useRadius * 2, 0, getWidth(), 0 + useRadius * 2), -90, 90);
        path.close();
        canvas.drawPath(path, mPaint);
    }

    private float getRadius(float mRadius) {
        float r = radius == -1 ? mRadius : radius;
        int mHeight = getHeight() / 2;
        return r > mHeight ? mHeight : r;
    }
}