package cn.lsmya.view.utils;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;

import java.util.Arrays;

import cn.lsmya.view.R;

public class SuperViewHelper {

    /**
     * top-left, top-right, bottom-right, bottom-left
     */
    private float[] radiusList = new float[8];
    @ViewMeasureMode
    private int viewMeasureMode;
    private int startColor = -1;
    private int stopColor = -1;
    private int borderColor = Color.TRANSPARENT;
    private float borderWidth = 0f;
    private GradientDrawable.Orientation orientation = GradientDrawable.Orientation.LEFT_RIGHT;

    private Path mPath;
    private Paint mPaint;
    private Path mPathBorder;
    private Paint mPaintBorder;
    private RectF mRectF;
    private RectF mRectFBorder;
    private int paddingLeft;
    private int paddingRight;
    private int paddingTop;
    private int paddingBottom;


    public void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UISuperView);
        int radius = typedArray.getDimensionPixelSize(R.styleable.UISuperView_ui_radius, 0);
        Arrays.fill(radiusList, radius);
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.UISuperView_ui_borderColor) {
                borderColor = typedArray.getColor(attr, Color.TRANSPARENT);
            } else if (attr == R.styleable.UISuperView_ui_borderWidth) {
                borderWidth = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UISuperView_ui_tlRadius) {
                int tlRadius = typedArray.getDimensionPixelSize(attr, 0);
                Arrays.fill(radiusList, 0, 2, tlRadius);
            } else if (attr == R.styleable.UISuperView_ui_blRadius) {
                int blRadius = typedArray.getDimensionPixelSize(attr, 0);
                Arrays.fill(radiusList, 6, 8, blRadius);
            } else if (attr == R.styleable.UISuperView_ui_trRadius) {
                int trRadius = typedArray.getDimensionPixelSize(attr, 0);
                Arrays.fill(radiusList, 2, 4, trRadius);
            } else if (attr == R.styleable.UISuperView_ui_brRadius) {
                int brRadius = typedArray.getDimensionPixelSize(attr, 0);
                Arrays.fill(radiusList, 4, 6, brRadius);
            } else if (attr == R.styleable.UISuperView_ui_maxSize) {
                viewMeasureMode = typedArray.getInt(attr, 0);
            } else if (attr == R.styleable.UISuperView_ui_startColor) {
                startColor = typedArray.getColor(attr, -1);
            } else if (attr == R.styleable.UISuperView_ui_stopColor) {
                stopColor = typedArray.getColor(attr, -1);
            } else if (attr == R.styleable.UISuperView_ui_orientation) {
                orientation = getOrientation(typedArray.getInt(attr, -1));
            }
        }
        typedArray.recycle();

        mPath = new Path();
        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setStyle(Paint.Style.FILL);
        mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        mRectF = new RectF();

        mPathBorder = new Path();
        mPaintBorder = new Paint();
        mPaintBorder.setStrokeWidth(getBorderWidth());
        mPaintBorder.setColor(getBorderColor());
        mPaintBorder.setAntiAlias(true);
        mPaintBorder.setStyle(Paint.Style.STROKE);
        mRectFBorder = new RectF();

    }

    public void update(int w, int h) {
        if (w > 0) {
            float bw = getBorderWidth() / 2;
            mPath.reset();
            mPath.setFillType(Path.FillType.INVERSE_EVEN_ODD);
            mRectF.set(bw, bw, w - bw, h - bw);
            mPath.addRoundRect(mRectF, getRadiusList(), Path.Direction.CW);
            mPath.close();

            mPaintBorder.setColor(getBorderColor());
            mPathBorder.reset();
            mRectFBorder.set(bw, bw, w - bw, h - bw);
            mPathBorder.addRoundRect(mRectFBorder, getRadiusList(), Path.Direction.CW);
        }
    }

    public Path getPath() {
        return mPath;
    }

    public Paint getPaint() {
        return mPaint;
    }

    public Path getPathBorder() {
        return mPathBorder;
    }

    public Paint getPaintBorder() {
        return mPaintBorder;
    }

    public float[] getRadiusList() {
        return radiusList;
    }

    public float getTopLeftRadius() {
        return radiusList[0];
    }

    public float getTopRightRadius() {
        return radiusList[2];
    }

    public float getBottomRightRadius() {
        return radiusList[4];
    }

    public float getBottomLeftRadius() {
        return radiusList[6];
    }

    public void setRadiusList(float radius) {
        Arrays.fill(radiusList, radius);
    }

    public void setTopLeftRadius(float topLeftRadius) {
        Arrays.fill(radiusList, 0, 2, topLeftRadius);
    }

    public void setTopRightRadius(float topRightRadius) {
        Arrays.fill(radiusList, 2, 4, topRightRadius);
    }

    public void setBottomRightRadius(float bottomRightRadius) {
        Arrays.fill(radiusList, 4, 6, bottomRightRadius);
    }

    public void setBottomLeftRadius(float bottomLeftRadius) {
        Arrays.fill(radiusList, 6, 8, bottomLeftRadius);
    }

    public GradientDrawable.Orientation getOrientation() {
        return orientation;
    }

    public void setOrientation(GradientDrawable.Orientation orientation) {
        this.orientation = orientation;
    }

    public int getViewMeasureMode() {
        return this.viewMeasureMode;
    }

    public int getStartColor() {
        return startColor;
    }

    public int getStopColor() {
        return stopColor;
    }

    public int getBorderColor() {
        return borderColor;
    }

    public void setBorderColor(int borderColor) {
        this.borderColor = borderColor;
    }

    public float getBorderWidth() {
        return borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
        mPaintBorder.setStrokeWidth(getBorderWidth());
    }

    private GradientDrawable.Orientation getOrientation(int orientation) {
        switch (orientation) {
            case 0:
                return GradientDrawable.Orientation.TOP_BOTTOM;
            case 1:
                return GradientDrawable.Orientation.TR_BL;
            case 2:
                return GradientDrawable.Orientation.RIGHT_LEFT;
            case 3:
                return GradientDrawable.Orientation.BR_TL;
            case 4:
                return GradientDrawable.Orientation.BOTTOM_TOP;
            case 5:
                return GradientDrawable.Orientation.BL_TR;
            case 6:
                return GradientDrawable.Orientation.LEFT_RIGHT;
            case 7:
                return GradientDrawable.Orientation.TL_BR;
            default:
                return GradientDrawable.Orientation.LEFT_RIGHT;
        }
    }

    public void setPaddingLeft(int paddingLeft) {
        this.paddingLeft = paddingLeft;
    }

    public void setPaddingRight(int paddingRight) {
        this.paddingRight = paddingRight;
    }

    public void setPaddingTop(int paddingTop) {
        this.paddingTop = paddingTop;
    }

    public void setPaddingBottom(int paddingBottom) {
        this.paddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return paddingLeft + (int) (borderWidth / 2);
    }

    public int getPaddingRight() {
        return paddingRight+ (int) (borderWidth / 2);
    }

    public int getPaddingTop() {
        return paddingTop+ (int) (borderWidth / 2);
    }

    public int getPaddingBottom() {
        return paddingBottom+ (int) (borderWidth / 2);
    }
}
