package cn.lsmya.view.utils;

public interface RoundStatus {

    /**
     * 设置所有圆角的半径
     *
     * @param radius
     */
    void setRadius(float radius);

    /**
     * 设置左上角圆角半径
     *
     * @param topLeftRadius
     */
    void setTopLeftRadius(float topLeftRadius);

    /**
     * 设置右上角圆角半径
     *
     * @param topRightRadius
     */
    void setTopRightRadius(float topRightRadius);

    /**
     * 设置右下角圆角半径
     *
     * @param bottomRightRadius
     */
    void setBottomRightRadius(float bottomRightRadius);

    /**
     * 设置左下角圆角半径
     *
     * @param bottomLeftRadius
     */
    void setBottomLeftRadius(float bottomLeftRadius);

    /**
     * 设置边框宽度
     */
    void setBorderWidth(float width);

    /**
     * 设置边框颜色
     *
     * @param borderColor
     */
    void setBorderColor(int borderColor);

    /**
     * 获取左上角圆角半径
     *
     * @return
     */
    float getTopLeftRadius();

    /**
     * 获取右上角圆角半径
     *
     * @return
     */
    float getTopRightRadius();

    /**
     * 获取右下角圆角半径
     *
     * @return
     */
    float getBottomRightRadius();

    /**
     * 获取左下角圆角半径
     *
     * @return
     */
    float getBottomLeftRadius();

    /**
     * 获取边框宽度
     */
    float getBorderWidth();

    /**
     * 获取边框颜色
     */
    int getBorderColor();

    /**
     * 获取最大尺寸模式
     *
     * @return
     */
    int getViewMeasureMode();

    /**
     * 获取渐变色开始颜色
     *
     * @return
     */
    int getStartColor();

    /**
     * 获取渐变色结束颜色
     *
     * @return
     */
    int getStopColor();

    /**
     * 刷新ui
     */
    void update(int w,int h);
}