package cn.lsmya.view.layout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;

import cn.lsmya.view.utils.RoundStatus;
import cn.lsmya.view.utils.SuperViewHelper;
import cn.lsmya.view.utils.ViewMeasureMode;

/**
 * 可直接设置圆角、边框的RelativeLayout
 *
 * @author lsm
 */
public class UISuperLinearLayout extends LinearLayout implements RoundStatus {

    private SuperViewHelper helper;

    public UISuperLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context, attrs);
    }

    public UISuperLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UISuperLinearLayout(Context context) {
        this(context, null);
    }

    private void init(Context context, AttributeSet attrs) {
        helper = new SuperViewHelper();
        helper.initAttrs(context, attrs);
        //关闭硬件加速
        setLayerType(View.LAYER_TYPE_SOFTWARE, null);

        helper.setPaddingLeft(getPaddingLeft());
        helper.setPaddingRight(getPaddingRight());
        helper.setPaddingTop(getPaddingTop());
        helper.setPaddingBottom(getPaddingBottom());

        if (getStartColor() != -1 && getStopColor() != -1) {
            int[] colors = {getStartColor(), getStopColor()};
            GradientDrawable mGradientDrawable = new GradientDrawable();
            mGradientDrawable.setOrientation(helper.getOrientation());
            mGradientDrawable.setColors(colors);
            setBackground(mGradientDrawable);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        helper.update(w, h);
        setPadding(helper.getPaddingLeft(), helper.getPaddingTop(), helper.getPaddingRight(), helper.getPaddingBottom());
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (getViewMeasureMode() == ViewMeasureMode.WIDTH) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childWidthSize = getMeasuredWidth();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childWidthSize, MeasureSpec.EXACTLY);
        } else if (getViewMeasureMode() == ViewMeasureMode.HEIGHT) {
            setMeasuredDimension(getDefaultSize(0, widthMeasureSpec), getDefaultSize(0, heightMeasureSpec));
            int childHeightSize = getMeasuredHeight();
            //高度和宽度一样
            heightMeasureSpec = widthMeasureSpec = MeasureSpec.makeMeasureSpec(childHeightSize, MeasureSpec.EXACTLY);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        canvas.drawPath(helper.getPath(), helper.getPaint());
        if (getBorderWidth() > 0) {
            canvas.drawPath(helper.getPathBorder(), helper.getPaintBorder());
        }
    }

    @Override
    public void setRadius(float radius) {
        helper.setRadiusList(radius);
        update(getWidth(), getHeight());
    }

    @Override
    public void setTopLeftRadius(float topLeftRadius) {
        helper.setTopLeftRadius(topLeftRadius);
        update(getWidth(), getHeight());
    }

    @Override
    public void setTopRightRadius(float topRightRadius) {
        helper.setTopRightRadius(topRightRadius);
        update(getWidth(), getHeight());
    }

    @Override
    public void setBottomRightRadius(float bottomRightRadius) {
        helper.setBottomRightRadius(bottomRightRadius);
        update(getWidth(), getHeight());
    }

    @Override
    public void setBottomLeftRadius(float bottomLeftRadius) {
        helper.setBottomLeftRadius(bottomLeftRadius);
        update(getWidth(), getHeight());
    }

    @Override
    public void setBorderWidth(float width) {
        helper.setBorderWidth(width);
        update(getWidth(), getHeight());
    }

    @Override
    public void setBorderColor(int borderColor) {
        helper.setBorderColor(borderColor);
    }

    @Override
    public float getTopLeftRadius() {
        return helper.getTopLeftRadius();
    }

    @Override
    public float getTopRightRadius() {
        return helper.getTopRightRadius();
    }

    @Override
    public float getBottomRightRadius() {
        return helper.getBottomRightRadius();
    }

    @Override
    public float getBottomLeftRadius() {
        return helper.getBottomLeftRadius();
    }

    @Override
    public float getBorderWidth() {
        return helper.getBorderWidth();
    }

    @Override
    public int getBorderColor() {
        return helper.getBorderColor();
    }

    @Override
    public int getViewMeasureMode() {
        return helper.getViewMeasureMode();
    }

    @Override
    public int getStartColor() {
        return helper.getStartColor();
    }

    @Override
    public int getStopColor() {
        return helper.getStopColor();
    }


    @Override
    public void update(int w, int h) {
        helper.update(w, h);
        setPadding(helper.getPaddingLeft(), helper.getPaddingTop(), helper.getPaddingRight(), helper.getPaddingBottom());
        invalidate();
    }
}
