package cn.lsmya.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

public class UIItemView extends LinearLayout {
    private ImageView leftImageView;
    private ImageView rightImageView;
    private TextView titleTextView;
    private TextView descTextView;
    private TextView badgeTextView;
    private View dividerView;
    private int leftIconId = -1;
    private int paddingLeft = dp2px(15);
    private int paddingRight = dp2px(15);
    private int marginTitleIcon = dp2px(10);

    public UIItemView(Context context) {
        super(context);
        init(context, null);
    }

    public UIItemView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public UIItemView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        View view = inflate(context, R.layout.ui_item, this);
        leftImageView = view.findViewById(R.id.helperItem_leftImageView);
        rightImageView = view.findViewById(R.id.helperItem_rightImageView);
        ImageView descImageView = view.findViewById(R.id.helperItem_descImageView);
        titleTextView = view.findViewById(R.id.helperItem_titleTextView);
        descTextView = view.findViewById(R.id.helperItem_descTextView);
        badgeTextView = view.findViewById(R.id.helperItem_badgeTextView);
        dividerView = view.findViewById(R.id.helperItem_dividerLine);
        RelativeLayout contentLayout = view.findViewById(R.id.helperItem_contentLayout);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.UIItemView);
        boolean dividerAlignToTitle = false;
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.UIItemView_ui_leftIcon) {
                leftIconId = typedArray.getResourceId(attr, -1);
                if (leftIconId != -1) {
                    leftImageView.setVisibility(VISIBLE);
                    leftImageView.setImageResource(leftIconId);
                } else {
                    leftImageView.setVisibility(GONE);
                }
            } else if (attr == R.styleable.UIItemView_ui_leftIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(40));
                RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) leftImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                leftImageView.setLayoutParams(layoutParams);

            } else if (attr == R.styleable.UIItemView_ui_title) {
                titleTextView.setText(typedArray.getString(attr));
            } else if (attr == R.styleable.UIItemView_ui_titleSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, dp2px(18));
                titleTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.UIItemView_ui_titleColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                titleTextView.setTextColor(color);
            } else if (attr == R.styleable.UIItemView_ui_badgeSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(16));
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) badgeTextView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                badgeTextView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.UIItemView_ui_badgeCount) {
                int count = typedArray.getInt(attr, 0);
                if (count > 0) {
                    badgeTextView.setVisibility(VISIBLE);
                    count = Math.min(count, 99);
                    badgeTextView.setText(String.valueOf(count));
                }
            } else if (attr == R.styleable.UIItemView_ui_badgeTextSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, dp2px(12));
                badgeTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.UIItemView_ui_desc) {
                String desc = typedArray.getString(attr);
                if (!TextUtils.isEmpty(desc)) {
                    descTextView.setVisibility(VISIBLE);
                    descTextView.setText(desc);
                }
            } else if (attr == R.styleable.UIItemView_ui_descHint) {
                String descHint = typedArray.getString(attr);
                if (!TextUtils.isEmpty(descHint)) {
                    descTextView.setVisibility(VISIBLE);
                    descTextView.setHint(descHint);
                }
            } else if (attr == R.styleable.UIItemView_ui_descSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, dp2px(18));
                descTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.UIItemView_ui_descColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                descTextView.setTextColor(color);
            } else if (attr == R.styleable.UIItemView_ui_rightIcon) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    rightImageView.setImageResource(resId);
                    rightImageView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.UIItemView_ui_rightIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(40));
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) rightImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                rightImageView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.UIItemView_ui_descSrc) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    descImageView.setImageResource(resId);
                    descImageView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.UIItemView_ui_descIconSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(40));
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) descImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                descImageView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.UIItemView_ui_showDivider) {
                boolean aBoolean = typedArray.getBoolean(attr, false);
                if (aBoolean) {
                    dividerView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.UIItemView_ui_dividerAlignToTitle) {
                dividerAlignToTitle = typedArray.getBoolean(attr, false);
            } else if (attr == R.styleable.UIItemView_ui_dividerColor) {
                dividerView.setBackgroundColor(typedArray.getColor(attr, Color.BLACK));
            } else if (attr == R.styleable.UIItemView_ui_dividerHeight) {
                int dividerHeight = typedArray.getDimensionPixelSize(attr, 0);
                ViewGroup.LayoutParams layoutParams = dividerView.getLayoutParams();
                layoutParams.height = dividerHeight;
                dividerView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.UIItemView_ui_marginLeft) {
                paddingLeft = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UIItemView_ui_marginRight) {
                paddingRight = typedArray.getDimensionPixelSize(attr, 0);
            } else if (attr == R.styleable.UIItemView_ui_margin_title_icon) {
                marginTitleIcon = typedArray.getDimensionPixelSize(attr, 0);
            }
        }
        //设置左右边距
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams) contentLayout.getLayoutParams();
        lp.leftMargin = paddingLeft;
        lp.rightMargin = paddingRight;
        contentLayout.setLayoutParams(lp);
        //设置标题与左边Icon之间的距离
        if (leftIconId!= -1){
            titleTextView.setPadding(marginTitleIcon,0,0,0);
        }
        if (dividerAlignToTitle) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) dividerView.getLayoutParams();
            int dimension = typedArray.getDimensionPixelSize(R.styleable.UIItemView_ui_leftIconSize, dp2px(40));
            int margin = leftImageView.getVisibility() == VISIBLE ? (32 + px2dp(dimension)) : 16;
            layoutParams.leftMargin = dp2px(margin);
            layoutParams.rightMargin = dp2px(margin);
            dividerView.setLayoutParams(layoutParams);
            dividerView.invalidate();
        }
        typedArray.recycle();
    }

    public ImageView getLeftImageView() {
        return leftImageView;
    }

    public ImageView getRightImageView() {
        return rightImageView;
    }

    public void setTitle(String title) {
        if (titleTextView != null) {
            titleTextView.setText(title);
            leftImageView.setVisibility(VISIBLE);
        }
    }

    public String getTitle() {
        if (titleTextView != null) {
            return titleTextView.getText().toString();
        }
        return "";
    }

    public void setBadgeCount(int value) {
        if (badgeTextView != null) {
            if (value > 0) {
                badgeTextView.setVisibility(VISIBLE);
                value = Math.min(value, 99);
                badgeTextView.setText(String.valueOf(value));
            } else {
                badgeTextView.setVisibility(GONE);
            }
        }
    }

    public String getBadgeCount() {
        if (badgeTextView != null) {
            return badgeTextView.getText().toString();
        }
        return "";
    }

    public void setDesc(String desc) {
        if (descTextView != null) {
            if (TextUtils.isEmpty(desc)) {
                descTextView.setVisibility(GONE);
            } else {
                descTextView.setVisibility(VISIBLE);
                descTextView.setText(desc);
            }
        }
    }

    public String getDesc() {
        if (descTextView != null) {
            return descTextView.getText().toString();
        }
        return "";
    }


    public void setDividerVisibility(int visibility) {
        if (dividerView != null) {
            dividerView.setVisibility(visibility);
        }
    }

    private int dp2px(int dip) {
        float density = getContext().getResources().getDisplayMetrics().density;
        return (int) (dip * density + 0.5f);
    }

    private int px2dp(float pxValue) {
        final float scale = getContext().getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }
}