package cn.lsmya.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;

/**
 * 水波纹效果
 */
public class UIWaveView extends View {

    private int mHeight;
    private int mWidth;
    private float[] mContentOneYs = null;
    private float[] mContentTwoYs = null;
    private float[] mContentThreeYs = null;
    private float[] mRestoreOnes = null;
    private float[] mRestoreTwos = null;
    private float[] mRestoreThrees = null;
    /**
     * 波动幅度
     */
    private static final int SWINGONE = 40;
    private static final int SWINGTWO = 50;
    private static final int SWINGTHREE = 60;
    /**
     * 偏移量
     */
    private static final int OFFSETONE = 30;
    private static final int OFFSETTWO = 40;
    private static final int OFFSETTHREE = 50;
    private int mPosition1 = 0;
    private int mPosition2 = 0;
    private int mPosition3 = 0;
    private static final int STEP1 = 3;
    private static final int STEP2 = 5;
    private static final int STEP3 = 4;
    private Paint mPaint1;
    private Paint mPaint2;
    private Paint mPaint3;

    private int backgroundColor = Color.parseColor("#32bfb9");

    private int alpha = 40;

    public UIWaveView(Context context) {
        this(context, null);
    }

    public UIWaveView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public UIWaveView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs);
    }

    private void init(AttributeSet attrs) {

        TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.UIWaveView);
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.UIWaveView_ui_color) {
                backgroundColor = typedArray.getColor(attr, Color.parseColor("#32bfb9"));
            }
        }
        typedArray.recycle();

        mPaint1 = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint1.setColor(backgroundColor);
        mPaint1.setStrokeWidth(4);
        mPaint1.setAlpha(alpha);

        mPaint2 = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint2.setColor(backgroundColor);
        mPaint2.setStrokeWidth(4);
        mPaint2.setAlpha(alpha);

        mPaint3 = new Paint(Paint.ANTI_ALIAS_FLAG);
        mPaint3.setColor(backgroundColor);
        mPaint3.setStrokeWidth(4);
        mPaint3.setAlpha(alpha);
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != 0 || h != 0 || w != oldw || h != oldh) {
            mWidth = w;
            mHeight = h;
            calculatePoints();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        changeRestorePosition();
        for (int i = 0; i < mWidth; i++) {
            final int x = i;
            final float y1 = mRestoreOnes[i];
            final float y2 = mRestoreTwos[i];
            final float y3 = mRestoreThrees[i];
            //正负代表水波纹的位置    正：水波纹在上方    负：水波纹在下方
            canvas.drawLine(x, y3, x, -mHeight, mPaint3);
            canvas.drawLine(x, y2, x, -mHeight, mPaint2);
            canvas.drawLine(x, y1, x, -mHeight, mPaint1);
        }
        invalidate();
    }

    private void calculatePoints() {
        mContentOneYs = new float[mWidth];
        mContentTwoYs = new float[mWidth];
        mContentThreeYs = new float[mWidth];
        mRestoreOnes = new float[mWidth];
        mRestoreTwos = new float[mWidth];
        mRestoreThrees = new float[mWidth];
        for (int i = 0; i < mWidth; i++) {
            mContentOneYs[i] = getYPosition(i, SWINGONE, OFFSETONE, mHeight);
            mContentTwoYs[i] = getYPosition(i, SWINGTWO, OFFSETTWO, mHeight);
            mContentThreeYs[i] = getYPosition(i, SWINGTHREE, OFFSETTHREE, mHeight);
        }
    }


    private void changeRestorePosition() {
        if (mWidth != 0) {
            mPosition1 = (mPosition1 + STEP1) % mWidth;
            System.arraycopy(mContentOneYs, mPosition1, mRestoreOnes, 0, mWidth - mPosition1);
            System.arraycopy(mContentOneYs, 0, mRestoreOnes, mWidth - mPosition1, mPosition1);

            mPosition2 = (mPosition2 + STEP2) % mWidth;
            System.arraycopy(mContentTwoYs, mPosition2, mRestoreTwos, 0, mWidth - mPosition2);
            System.arraycopy(mContentTwoYs, 0, mRestoreTwos, mWidth - mPosition2, mPosition2);

            mPosition3 = (mPosition3 + STEP3) % mWidth;
            System.arraycopy(mContentThreeYs, mPosition3, mRestoreThrees, 0, mWidth - mPosition3);
            System.arraycopy(mContentThreeYs, 0, mRestoreThrees, mWidth - mPosition3, mPosition3);
        }
    }

    private float getYPosition(int x, int swing, int offset, int baseHeight) {
        float cycle = (float) (2 * Math.PI) / mWidth;
        return (float) Math.sin(cycle * x + offset) * swing + (baseHeight - swing);
    }

}