package cn.lsmya.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.widget.RelativeLayout;

import androidx.annotation.Nullable;

import cn.lsmya.view.R;

/**
 * 可直接设置圆角、边框的RelativeLayout
 * @author lsm
 */
public class RoundRelativeLayout extends RelativeLayout {
    private static final int OVAL = 0x1;
    private static final int RECTANGLE = 0x2;

    private GradientDrawable mGradientDrawable;

    public RoundRelativeLayout(Context context) {
        this(context, null);
    }

    public RoundRelativeLayout(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RoundRelativeLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.SuperTextView);
        float corner = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_corner, 0);
        float mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_topLeft, 0);
        float mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_topRight, 0);
        float mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_bottomLeft, 0);
        float mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_bottomRight, 0);
        int mBorderWidth = typedArray.getDimensionPixelSize(R.styleable.SuperTextView_borderWidth, 0);
        int mBorderColor = typedArray.getColor(R.styleable.SuperTextView_borderColor, Color.TRANSPARENT);
        int mShape = typedArray.getInt(R.styleable.SuperTextView_model, RECTANGLE);

        typedArray.recycle();

        mGradientDrawable = new GradientDrawable();
        mGradientDrawable.setOrientation(GradientDrawable.Orientation.LEFT_RIGHT);
        ColorDrawable background = (ColorDrawable) getBackground();
        if (background != null) {
            int backgroundColor = background.getColor();
            mGradientDrawable.setColor(backgroundColor);
        }
        mGradientDrawable.setStroke(mBorderWidth, mBorderColor);
        if (mTopLeftRadius != 0 || mTopRightRadius != 0 || mBottomLeftRadius != 0 || mBottomRightRadius != 0) {
            mGradientDrawable.setCornerRadii(new float[]{
                    mTopLeftRadius, mTopLeftRadius, mTopRightRadius, mTopRightRadius,
                    mBottomRightRadius, mBottomRightRadius, mBottomLeftRadius, mBottomLeftRadius});
        } else {
            if (corner != 0) {
                mGradientDrawable.setCornerRadius(corner);
            }
        }
        if (mShape == OVAL) {
            mGradientDrawable.setShape(GradientDrawable.OVAL);
        } else {
            mGradientDrawable.setShape(GradientDrawable.RECTANGLE);
        }
        setBackground(mGradientDrawable);
    }

}
